% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EFM.R
\name{EFM}
\alias{EFM}
\title{The EFM function is to generate Elliptical Factor Models data.}
\usage{
EFM(n, p, m, nu, distribution_type)
}
\arguments{
\item{n}{Sample size.}

\item{p}{Sample dimensionality.}

\item{m}{Number of factors.}

\item{nu}{A numerical parameter used exclusively in the "Elliptical-t" distribution, representing the degrees of freedom.}

\item{distribution_type}{The type of distribution ("Elliptical-Normal Distribution" or "Elliptical-t Distribution").}
}
\value{
A list containing:
\item{data}{A matrix of generated data (n x p).}
\item{A}{A matrix representing the factor loadings (p x m).}
\item{D}{A diagonal matrix representing the unique variances (p x p).}
}
\description{
The function supports various distribution types for generating the data,
including: Elliptical-Normal Distribution, Elliptical-t Distribution.
}
\examples{
library(MASS)
library(pracma)

n <- 2000
p <- 10
m <- 5
nu <- 5
distribution_type <- "Elliptical-Normal Distribution"
X <- EFM(n, p, m, nu, distribution_type)

}
