% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergoInfo.R
\name{ergoInfo}
\alias{ergoInfo}
\title{Ergodicity Information Index}
\usage{
ergoInfo(
  dynEGA.object,
  use = c("edge.list", "unweighted"),
  ordering = c("row", "column")
)
}
\arguments{
\item{dynEGA.object}{A \code{\link[EGAnet]{dynEGA.ind.pop}} object}

\item{use}{Character (length = 1).
A string indicating what network element will be used
to compute the algorithm complexity, the list of edges or the weights of the network.
Defaults to \code{use = "edge.list"}.
Current options are:

\itemize{

\item{\code{"edge.list"} --- }
{Calculates the algorithm complexity using the list of edges.}

\item{\code{"unweighted"} --- }
{Calculates the algorithm complexity using the binary weights of the network.
0 = edge absent and 1 = edge present}

}}

\item{ordering}{Character (length = 1).
Changes ordering of edge list.
\code{"row"} goes across the rows;
\code{"column"} goes down the columns.
Defaults to \code{"column"} (original implementation)}
}
\value{
Returns a list containing:

\item{PrimeWeight}{The prime-weight encoding of the individual networks}

\item{PrimeWeight.pop}{The prime-weight encoding of the population network}

\item{Kcomp}{The Kolmogorov complexity of the prime-weight encoded individual networks}

\item{Kcomp.pop}{The Kolmogorov complexity of the prime-weight encoded population network}

\item{complexity}{The complexity metric proposed by Santora and Nicosia (2020)}

\item{EII}{The Ergodicity Information Index}
}
\description{
Computes the Ergodicity Information Index
}
\examples{
# Obtain data
sim.dynEGA <- sim.dynEGA # bypasses CRAN checks

\dontrun{
# Dynamic EGA individual and population structure
dyn.ega1 <- dynEGA.ind.pop(
  data = sim.dynEGA[,-26], n.embed = 5, tau = 1,
  delta = 1, id = 25, use.derivatives = 1,
  ncores = 2, corr = "pearson"
)

# Compute empirical ergodicity information index
eii <- ergoInfo(
  dynEGA.object = dyn.ega1,
  use = "edge.list"
)}

}
\author{
Hudson Golino <hfg9s at virginia.edu> and Alexander Christensen <alexpaulchristensen@gmail.com>
}
