% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotConcQ.R
\name{plotConcQ}
\alias{plotConcQ}
\title{Plot of Observed Concentration versus Discharge}
\usage{
plotConcQ(eList, qUnit = 2, tinyPlot = FALSE, logScale = FALSE,
  concMax = NA, concMin = NA, printTitle = TRUE, cex = 0.8,
  cex.axis = 1.1, cex.main = 1.1, rmSciX = FALSE, rmSciY = FALSE,
  customPar = FALSE, col = "black", lwd = 1, ...)
}
\arguments{
\item{eList}{named list with at least the Sample and INFO dataframes}

\item{qUnit}{object of qUnit class \code{\link{printqUnitCheatSheet}}, or numeric represented the short code, or character representing the descriptive name.}

\item{tinyPlot}{logical variable, if TRUE plot is designed to be plotted small as part of a multipart figure, default is FALSE.}

\item{logScale}{logical if TRUE x and y plotted in log axis}

\item{concMax}{number specifying the maximum value to be used on the vertical axis, default is NA (which allows it to be set automatically by the data)}

\item{concMin}{numeric value for lower limit on concentration shown on the vertical log graph, default is NA 
(which causes the lower limit to be set automatically, based on the data). This value is ignored for linear scales, using 0 as the minimum value for the concentration axis.}

\item{printTitle}{logical variable if TRUE title is printed, if FALSE title is not printed (this is best for a multi-plot figure)}

\item{cex}{numerical value giving the amount by which plotting symbols should be magnified}

\item{cex.axis}{magnification to be used for axis annotation relative to the current setting of cex}

\item{cex.main}{magnification to be used for main titles relative to the current setting of cex}

\item{rmSciX}{logical defaults to FALSE, changes x label from scientific to fixed}

\item{rmSciY}{logical defaults to FALSE, changes y label from scientific to fixed}

\item{customPar}{logical defaults to FALSE. If TRUE, par() should be set by user before calling this function 
(for example, adjusting margins with par(mar=c(5,5,5,5))). If customPar FALSE, EGRET chooses the best margins depending on tinyPlot.}

\item{col}{color of points on plot, see ?par 'Color Specification'}

\item{lwd}{number line width}

\item{\dots}{arbitrary graphical parameters that will be passed to genericEGRETDotPlot function (see ?par for options)}
}
\description{
Data come from named list, which contains a Sample dataframe with the sample data, 
and an INFO dataframe with metadata. 
Discharge is plotted on a log scale.

Although there are a lot of optional arguments to this function, most are set to a logical default.
}
\examples{
eList <- Choptank_eList
# Water year:
plotConcQ(eList)
plotConcQ(eList, logScale=TRUE)
# Graphs consisting of Jun-Aug
eList <- setPA(eList, paStart=6,paLong=3)
plotConcQ(eList)
}
\seealso{
\code{\link{selectDays}}, \code{\link{genericEGRETDotPlot}}
}
\keyword{graphics}
\keyword{statistics}
\keyword{water-quality}

