% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processQWData.r
\name{processQWData}
\alias{processQWData}
\title{Processing of Water Quality Data}
\usage{
processQWData(data, pCode = TRUE)
}
\arguments{
\item{data}{dataframe from Water Quality Portal}

\item{pCode}{logical if TRUE, assume data came from a pCode search, if FALSE, characteristic name.}
}
\value{
data dataframe with first column dateTime, and at least one qualifier and value columns
(subsequent qualifier/value columns could follow depending on the number of parameter codes)
}
\description{
Processes water quality data. This function looks at detection limit and detection 
conditions to determine if a value is left censored or not. Censored values are given the qualifier
"<".  The dataframe is also converted from a long to wide format.
}
\examples{
\dontrun{
library(dataRetrieval)
 
rawWQP <- readWQPqw('21FLEECO_WQX-IMPRGR80','Phosphorus', '', '')
Sample2 <- processQWData(rawWQP, pCode=FALSE)
}
}
\seealso{
\code{\link[dataRetrieval]{readWQPqw}}
}
\keyword{USGS}
\keyword{data}
\keyword{import}
\keyword{service}
\keyword{web}
