% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ObsNumbs.R
\name{ObsNumbs}
\alias{ObsNumbs}
\title{Create observation numbers in your data}
\usage{
ObsNumbs(ID, TS, BY = c("P", "D", "PD"))
}
\arguments{
\item{ID}{name of ID variable}

\item{TS}{name unix (numeric) timestamp (if you have a date-time object, try converting it with as.numeric(as.POSIXct()))}

\item{BY}{participant (P), by day (D), or by participant and day (PD). P will create a column of just 1 through n responses for each participant. D will create a day-level sequential value. PD will create an observation within each day. This might be most useful by first using the BY=D option, which will give you day number to use in tandem with observation #.}
}
\value{
A column in your dataframe (with person-centered data)
}
\description{
This function allows you number your observations by participant (P), by day (D) or by participant and day (PD) using a unix (numeric) timestamp
}
\examples{
\dontrun{data$ObsNumb<-ObsNumbs(data$ID,data$TS, BY="P")}
\dontrun{data$DayNumb<-ObsNumbs(data$ID,data$TS,BY="D")}
\dontrun{data$ObsNumb_D<-ObsNumbs(data$ID,data$TS,BY="PD")}
}
\keyword{Numbers}
\keyword{Observation}
