% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend.R
\name{make_trend}
\alias{make_trend}
\title{Create a trend specification for model parameters}
\usage{
make_trend(
  par_names,
  cov_names = NULL,
  kernels,
  bases = NULL,
  shared = NULL,
  trend_pnames = NULL,
  phase = "premap",
  par_input = NULL,
  at = NULL,
  custom_trend = NULL
)
}
\arguments{
\item{par_names}{Character vector specifying which parameters to apply trend to}

\item{cov_names}{Character vector specifying which covariates to use for each trend}

\item{kernels}{Character vector specifying which kernel function to use for each trend}

\item{bases}{Optional character vector specifying which base function to use for each trend}

\item{shared}{Named list with entries the parameter names to be shared and the names the new names of the shared parameter.}

\item{trend_pnames}{Optional character vector specifying custom parameter names}

\item{phase}{Character vector (length 1 or \code{length(par_names)}) specifying the phase for each trend entry;
one of "premap", "pretransform", or "posttransform". Defaults to "premap".}

\item{par_input}{Optional character vector(s) of parameter names to use as additional inputs for the trend}

\item{at}{If NULL (default), trend is applied everywhere. If a factor name (e.g., "lR"), trend is applied only to entries corresponding to the first level of that factor.}

\item{custom_trend}{A trend registered with \code{register_trend}}
}
\value{
A list containing the trend specifications for each parameter
}
\description{
Create a trend specification for model parameters
}
\examples{
# Put trend on B and v parameters
trend <- make_trend(
  par_names = c("B", "v"),
  cov_names = "strial",
  kernels = c("exp_incr", "poly3"),
  phase = "premap",
  shared = list(shrd = list("B.B0", "v.d1"))
)
get_trend_pnames(trend)

}
