\name{test.lw}
\alias{test.lw}
\title{Function to test maximum valid lw value.}
\description{This function performs the weight transformation of the data matrix
after Klovan & Imbrie (1971) with different weight limits and returns the 
maximum value for which the transformation remains stable.}
\usage{test.lw(X, lw)}
\arguments{
  \item{X}{Numeric matrix with m samples (rows) and n variables (columns).}
  \item{lw}{Numeric vector specifying the weight transformation limit, i.e. 
quantile; default is 0.}
}

\value{A list with objects
\item{step}{Numeric scalar with position of last valid value.}
\item{lw.max}{Numeric scalar with last valid value of lw.}}
\references{Dietze E, Hartmann K, Diekmann B, IJmker J, Lehmkuhl F, Opitz S, 
Stauch G, Wuennemann B, Borchers A. 2012. An end-member algorithm for 
deciphering modern detrital processes from lake sediments of Lake Donggi 
Cona, NE Tibetan Plateau, China. Sedimentary Geology 243-244: 169-180. \cr
Klovan JE, Imbrie J. 1971. An Algorithm and FORTRAN-IV Program for 
Large-Scale Q-Mode Factor Analysis and Calculation of Factor Scores. 
Mathematical Geology 3: 61-77.}
\author{Michael Dietze, Elisabeth Dietze}



\seealso{\code{\link{EMMA}}, \code{\link{check.data}}, 
\code{\link{test.parameters}}}
\examples{
## load example data set
data(X.artificial, envir = environment())

## create weight transformation limits vector
lw <- seq(0, 0.6, by = 0.02)

## test the vector
test.lw(X = X.artificial, lw = lw)
}

\keyword{EMMA}
