% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{cluster_tissues}
\alias{cluster_tissues}
\title{Clusters tissues}
\usage{
cluster_tissues(gen, clusters, method = "t", q = 6, G = 2)
}
\arguments{
\item{gen}{EMMIXgene object}

\item{clusters}{mclust object}

\item{method}{Method for separating tissue classes. Can be either 't' for a 
univariate mixture of t-distributions on gene cluster means, or 'mfa'
for a mixture of factor analyzers.}

\item{q}{number of factors if using mfa}

\item{G}{number of components if using mfa}
}
\value{
a clustering for each sample (columns) by each group(rows)
}
\description{
Clusters tissues
}
\examples{
#only run on first 100 genes for speed
alon_sel <- select_genes(alon_data[seq_len(100), ]) 
alon_clust<- cluster_genes(alon_sel,2)
alon_tissue_t<-
   cluster_tissues(alon_sel,alon_clust,method='t')
alon_tissue_mfa<-
   cluster_tissues(alon_sel, alon_clust,method='mfa',q=2,G=2) 
}
