% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{orthogonalVectors}
\alias{orthogonalVectors}
\title{Orthogonal vectors}
\usage{
orthogonalVectors(X, dim = 1, re = TRUE)
}
\arguments{
\item{X}{a \code{matrix} with vectors as rows (default) or columns (see below).}

\item{dim}{an integer specifying which dimension is the object dimension.}

\item{re}{a logical indicating if vectors should be norm-scaled before
orthogonalization and rescaled afterwards (default = TRUE).}
}
\description{
Create orthogonal set of vectors that resemble the original input vectors.
}
\details{
The input vectors are orthgonalized using singular value
decomposition. To make the resulting vectors similar to the input
vectors (not just any base for the same space) they are re-oriented
towards the original vectors using Procrustes rotations.

To force the procedure to handle vectors of unequal magnitudes similarilly
they are by default rescaled to norm vectors before orthogonalization and
rescaled afterwards. This can be overridden using the \code{re} paramter.
}
\seealso{
\code{\link{EMSC}} \code{\link{EMSC_model}}  \code{\link{plot.EMSC}}
}
