% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multistack.pca.R
\name{multistack.pca}
\alias{multistack.pca}
\title{multistack.pca, simultaneous PCA on more than one stack of environmental rasters}
\usage{
multistack.pca(..., n = 2)
}
\arguments{
\item{...}{Any number of environmental raster stacks or bricks}

\item{n}{The number of PCA layers to return}
}
\value{
A list containing a stack or brick of rasters for each input set representing the top n pca axes of the initial environmental variables, as well as the pca object from the analysis that produced them and some useful plots showing the distribution of each PC in the different stacks.
}
\description{
multistack.pca, simultaneous PCA on more than one stack of environmental rasters
}
\examples{
\donttest{
world <- raster::getData(name = "worldclim", download = TRUE, var = "bio", res = 5)
test1 <- crop(world, extent(10, 15, 10, 15))
test2 <- crop(world, extent(17, 22, 17, 22))
test3 <- crop(world, extent(24, 26, 24, 26))
multistack.pca(test1, test2, test3)
}
}
\keyword{environment}
\keyword{pca}
\keyword{raster}
