% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmaxent_similarity.R
\name{similarity}
\alias{similarity}
\title{Calculate Multivariate Environmental Similarity}
\usage{
similarity(x, ref, full = FALSE)
}
\arguments{
\item{x}{a `Raster*`, `list`, `matrix`, or `data.frame`
where each layer/column/element represents focal values of an environmental
variable.}

\item{ref}{a `list`, `matrix`, or `data.frame` where each
column/element represents reference values for an environmental variable
(corresponding to those given in `x`).}

\item{full}{(logical) should similarity values be returned for all variables?
If `FALSE` (the default), then only the minimum similarity scores
across variables will be returned.}
}
\value{
If `x` is a `Raster*` object, this function returns a list 
  containing:
  - `similarity`: a `RasterStack` giving the environmental similarities for
  each variable in `x` (only included when `full=TRUE`); 
  - `similarity_min`: a `Raster` layer giving the minimum similarity value 
  across all variables for each location (i.e. the MESS);
  - `mod`: a factor `Raster` layer indicating which variable was most 
  dissimilar to its reference range (i.e. the MoD map, Elith \emph{et al.} 2010); 
  and
  - `mos`: a factor `Raster` layer indicating which variable was most 
  similar to its reference range.
  
  If `x` is a `list`, `matrix`, or `data.frame`, the function will return
  a list as above, but with `RasterStack` and `Raster` objects replaced by 
  matrix and vectors.
}
\description{
NOTICE: This function was borrowed from the rmaxent package written by John Baumgartner (https://github.com/johnbaums/rmaxent/).

Calculate Multivariate Environmental Similarity and most dissimilar/similar 
variables with respect to a reference dataset, for a set of environmental 
variables.
}
\details{
`similarity` uses the MESS algorithm described in Appendix S3
  of Elith \emph{et al.} 2010.
}
\examples{
library(dismo)
library(raster)
ff <- list.files(system.file('ex', package='dismo'), '\\\\.grd$', 
                 full.names=TRUE )
predictors <- stack(grep('biome', ff, value=TRUE, invert=TRUE))
occ <- read.csv(system.file('ex/bradypus.csv', package='dismo'))[, -1]
ref <- extract(predictors, occ)
mess <- similarity(predictors, ref, full=TRUE)

\dontrun{
library(rasterVis)
library(RColorBrewer)
levelplot(mess$mod, col.regions=brewer.pal(8, 'Set1'))
levelplot(mess$mos, col.regions=brewer.pal(8, 'Set1'))
}
}
\references{
Elith, J., Kearney, M., and Phillips, S. (2010) The art of modelling range-shifting species. \emph{Methods in Ecology and Evolution}, \bold{1}: 330-342. \doi{doi:10.1111/j.2041-210X.2010.00036.x}
}
