% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN.R
\name{get_excesses}
\alias{get_excesses}
\title{Computes rescaled excesses over the conditional quantiles}
\usage{
get_excesses(
  X = NULL,
  y,
  quantiles,
  intermediate_q_feature = FALSE,
  scale_features = FALSE,
  X_scaling = NULL
)
}
\arguments{
\item{X}{A covariate matrix. Can be \code{NULL} if there are no covariates.}

\item{y}{The response variable vector.}

\item{quantiles}{The intermediate quantiles over which to compute the excesses of \code{y}.}

\item{intermediate_q_feature}{Whether to use the intermediate \code{quantiles} as an additional covariate,
by appending it to the \code{X} matrix (bool).}

\item{scale_features}{Whether to rescale each input covariates to zero mean and unit variance before applying the network (recommended).
If \code{X_scaling} is given, \code{X_scaling$scaling} overrides \code{scale_features}.}

\item{X_scaling}{Existing \code{"X_scaling"} object containing the precomputed mean and variance for each covariate.
This enables reusing the scaling choice and parameters from the train set, if computing the excesses on a validation or test set,
in order to avoid overfitting. This is performed automatically in the \code{"EQRN"} objects.}
}
\value{
Named list containing:
\item{Y_excesses}{thematrix of response excesses,}
\item{X_excesses}{the (possibly rescaled and q_feat transformed) covariate matrix,}
\item{X_scaling}{object of class \code{"X_scaling"} to use for consistent scaling on future datasets,}
\item{excesses_ratio}{and the ratio of escesses for troubleshooting.}
}
\description{
Computes rescaled excesses over the conditional quantiles
}
