% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ictab.R
\name{ictab}
\alias{ictab}
\title{Computes Akaike weights for a set of models}
\usage{
ictab(ic, ...)
}
\arguments{
\item{ic}{Indicates which information criterion to use.}

\item{...}{A set of models of class \code{lm} or \code{merMod}.}
}
\description{
Returns a table with Akaike weights of a set of models, based on various
information criteria. Currently, \code{ictab} supports the computation of
Akaike weights from the \code{aic} or the \code{bic} computed on \code{lm}
or \code{merMod} models.
}
\examples{
data(mtcars)
mod1 <- lm(mpg ~ cyl, mtcars)
mod2 <- lm(mpg ~ cyl + vs, mtcars)
mod3 <- lm(mpg ~ cyl + vs + I(vs^2), mtcars)
mod4 <- lm(mpg ~ cyl * vs, mtcars)
ictab(aic, mod1, mod2, mod3, mod4)
ictab(bic, mod1, mod2, mod3, mod4)

}
\references{
Burnham, K. P., \& Anderson, D. R. (2002). Model Selection
and Multimodel Inference: A Practical Information-Theoretical Approach.
2d ed. New York: Springer-Verlag.

Burnham, K. P., \& Anderson, D. R. (2004). Multimodel
inference: Understanding AIC and BIC in model selection. Sociological
Methods and Research, 33(2), 261-304.
}
\seealso{
\code{\link{aic}}, \code{\link{bic}}
}
\author{
Ladislas Nalborczyk <\email{ladislas.nalborczyk@gmail.com}>
}
