% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviant_update.R
\name{deviant_update}
\alias{deviant_update}
\title{Deviant Updater function}
\usage{
deviant_update(new_cases, cum = FALSE, r_a = 7, r = 0.2, lag_max = 30)
}
\arguments{
\item{new_cases}{the time series of the newly observed cases per unit of time (ideally per day).}

\item{cum}{TRUE if the time series is recorded as the cumulative number of the reported cases and FALSE (the default) if newly reported cases per unit of time are recorded.}

\item{r_a}{The window size for the moving average that will be analyzed. If set to 1 the actual observations are analyzed. However, due to the variability of the reported cases between working days and weekends it is recommended that the 7-day moving average is analyzed (i.e. r_a = 7), which is the default for this argument. Users could prefer a longer interval of 14 days or one month (i.e., r_a=14 or 30, respectively).}

\item{r}{Definition for the minimum difference in the mean number of cases, one week before and after each time point that, if present, should be detected. This is the case definition and the default is 0.2 (with 0 <= r <= 1). A value of r=0.2 means that we have a case when the mean number of the newly observed cases in the next 7 days is at least 20\% higher than the mean number of the newly observed cases in the past 7 days.}

\item{lag_max}{Integer. Restriction of the maximum window size for the rolling window size. The default is set to one month (lag_max=30) to prevent excess volatility of past epidemic waves from affecting the most recent volatility estimates and the ability of EVI to warn for upcoming waves that may be smaller and of lower volatility than previous ones.}
}
\value{
After running the deviant_update() function the output of the deviant function (EVI_output) is also updated with a new row of data for each newly observed time point.
}
\description{
This function is used after first running the deviant function.
Once the \code{\link[EVI:deviant]{deviant()}} function has been used to analyze the already observed time series,
the deviant_update() function is used to obtain the EVI output and issue early warnings for the new cases that are recorded.
}
\examples{
     \dontrun{
        # Epidemic Volatility Index (EVI) Explained:
	       vignette('EVI', package='EVI')
	       
       # For information on how to cite EVI:
       citation('EVI')
    }

}
\references{
Kostoulas, P., Meletis, E., Pateras, K. et al. The epidemic volatility index, a novel early warning tool for identifying new waves in an epidemic. Sci Rep 11, 23775 (2021). \doi{10.1038/s41598-021-02622-3}
}
