% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect_measures.R
\name{convert_measures}
\alias{convert_measures}
\alias{toRR}
\alias{toMD}
\title{Convert an effect measure}
\usage{
toRR(est, rare, delta = 1, ...)

toMD(est, delta = 1, ...)
}
\arguments{
\item{est}{The effect estimate; constructed with one of \code{\link[=RR]{RR()}}, \code{\link[=OR]{OR()}}, \code{\link[=HR]{HR()}},
\code{\link[=MD]{MD()}}, \code{\link[=OLS]{OLS()}}.}

\item{rare}{When converting a \code{\link[=OR]{OR()}} or \code{\link[=HR]{HR()}} estimate, a logical indicating
whether the outcome is sufficiently rare to approximate a risk ratio.}

\item{delta}{When converting an \code{\link[=OLS]{OLS()}} estimate, the contrast of interest
in the exposure. Defaults to 1 (a 1-unit contrast in the exposure).}

\item{...}{Arguments passed to other methods.}
}
\value{
An object of class "estimate" and the desired effect measure. Also
includes as an attribute its conversion history.
}
\description{
These helper functions are mostly used internally to convert
\link[=effect_measures]{effect measures} for the calculation of E-values. The
approximate conversion of odds and hazard ratios to risk ratios depends on
whether the rare outcome assumption is made.
}
\details{
Uses the conversions listed in Table 2 of VanderWeele TJ, Ding P.
\emph{Sensitivity Analysis in Observational Research: Introducing the E-Value.}
Annals of Internal Medicine. 2017;167(4):268–75.

See references.

Regarding the continuous outcome, the function uses the effect-size
conversions in Chinn (2000) and VanderWeele (2017) to approximately convert
the mean difference between these exposure "groups" to the odds ratio that
would arise from dichotomizing the continuous outcome.
}
\examples{
# Both odds ratios are 3, but will be treated differently
# depending on whether rare outcome assumption is reasonable
OR(3, rare = FALSE)
OR(3, rare = TRUE)
toRR(OR(3, rare = FALSE))
toRR(OR(3, rare = TRUE))
attributes(toRR(toMD(OLS(3, sd = 1.2), delta = 1)))
}
\references{
Chinn, S (2000). A simple method for converting an odds ratio to
effect size for use in meta-analysis. \emph{Statistics in Medicine}, 19(22),
3127-3131.

VanderWeele, TJ (2017). On a square-root transformation of the odds ratio for
a common outcome. \emph{Epidemiology}, 28(6), e58.

VanderWeele TJ (2020). \emph{Optimal approximate conversions of odds ratios and
hazard ratios to risk ratios.} Biometrics.
}
