% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biases.R
\name{misclassification}
\alias{misclassification}
\title{Misclassification}
\usage{
misclassification(
  ...,
  rare_outcome = FALSE,
  rare_exposure = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{...}{Arguments describing the type of misclassification. Currently two
options: "outcome" or "exposure".}

\item{rare_outcome}{Logical. Is the outcome rare enough that outcome odds
ratios approximate risk ratios? Only needed when considering exposure
misclassification. Note that \code{rare_outcome = FALSE} returns an error, as
this option is not currently available.}

\item{rare_exposure}{Logical. Is the exposure rare enough that exposure odds
ratios approximate risk ratios? Only needed when considering exposure
misclassification.}

\item{verbose}{Logical. If \code{TRUE}, returns warnings and messages immediately.
Defaults to \code{FALSE} because it is generally used within the \code{\link[=multi_bias]{multi_bias()}}
function, which will print the same messages/warnings.}
}
\value{
Invisibly returns a list with components whose values depend on the
options chosen: \code{n} (the degree of the polynomial in the numerator), \code{d}
(the degree of the polynomial in the denominator), \code{m} (the parameters in
the bias factor), \code{mess} (any messages/warnings that should be printed for
the user), and \code{bias}("misclassification").
}
\description{
A type of bias. Declares that (differential) misclassification
will be a component of interest in the multi-bias sensitivity analysis.
Generally used within other functions; its output is returned invisibly.
}
\examples{
# returns invisibly without print()
print(misclassification("outcome"))

# Calculate an E-value for misclassification
multi_evalue(est = RR(4),
         biases = misclassification("exposure",
                  rare_outcome = TRUE, rare_exposure = TRUE))

}
\keyword{multi-bias}
