% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta-analysis.R
\name{sens_plot}
\alias{sens_plot}
\title{Plots for sensitivity analyses}
\usage{
sens_plot(
  method = "calibrated",
  type,
  q,
  CI.level = 0.95,
  tail = NA,
  muB.toward.null = FALSE,
  give.CI = TRUE,
  Bmin = 0,
  Bmax = log(4),
  breaks.x1 = NA,
  breaks.x2 = NA,
  muB,
  sigB,
  yr,
  vyr = NA,
  t2,
  vt2 = NA,
  R = 1000,
  dat = NA,
  yi.name = NA,
  vi.name = NA
)
}
\arguments{
\item{method}{\code{"calibrated"} or \code{"parametric"}. See Details.}

\item{type}{\code{dist} for distribution plot; \code{line} for line plot (see Details)}

\item{q}{True causal effect size chosen as the threshold for a meaningfully large effect}

\item{CI.level}{Pointwise confidence level as a proportion (e.g., 0.95).}

\item{tail}{\code{"above"} for the proportion of effects above \code{q}; \code{"below"} for
the proportion of effects below \code{q}. By default, is set to \code{"above"} if the pooled point estimate (\code{method = "parametric"}) or median of the calibrated estimates (\code{method = "calibrated"}) is above 1 on the relative risk scale and is set to \code{"below"} otherwise.}

\item{muB.toward.null}{Whether you want to consider bias that has on average shifted studies' point estimates away from the null (\code{FALSE}; the default) or that has on average shifted studies' point estimates toward the null (\code{TRUE}). See Details.}

\item{give.CI}{Logical. If \code{TRUE}, a pointwise confidence intervals is plotted.}

\item{Bmin}{Lower limit of lower X-axis on the log scale (only needed if \code{type = "line"}).}

\item{Bmax}{Upper limit of lower X-axis on the log scale (only needed if \code{type = "line"})}

\item{breaks.x1}{Breaks for lower X-axis (bias factor) on RR scale. (optional for \code{type = "line"}; not used for \code{type = "dist"}).}

\item{breaks.x2}{Breaks for upper X-axis (confounding strength) on RR scale (optional for \code{type = "line"}; not used for \code{type = "dist"})}

\item{muB}{Single mean bias factor on log scale (only needed if \code{type = "dist"})}

\item{sigB}{Standard deviation of log bias factor across studies (only used if \code{method = "parametric"})}

\item{yr}{Pooled point estimate (on log scale) from confounded meta-analysis (only used if \code{method = "parametric"})}

\item{vyr}{Estimated variance of pooled point estimate from confounded meta-analysis (only used if \code{method = "parametric"})}

\item{t2}{Estimated heterogeneity (\eqn{\tau^2}) from confounded meta-analysis (only used if \code{method = "parametric"})}

\item{vt2}{Estimated variance of \eqn{\tau^2} from confounded meta-analysis (only used if \code{method = "parametric"})}

\item{R}{Number  of  bootstrap  iterates for confidence interval estimation. Only used if \code{method = "calibrated"} and \code{give.CI = TRUE}.}

\item{dat}{Dataframe containing studies' point estimates and variances. Only used if \code{method = "calibrated"}.}

\item{yi.name}{Name of variable in \code{dat} containing studies' point estimates. Only used if \code{method = "calibrated"}.}

\item{vi.name}{Name of variable in \code{dat} containing studies' variance estimates. Only used if \code{method = "calibrated"}.}
}
\description{
Produces line plots (\code{type="line"}) showing the average bias factor across studies on the relative risk (RR) scale vs. the estimated proportion
of studies with true RRs above or below a chosen threshold \code{q}.
The plot secondarily includes a X-axis showing the minimum strength of confounding
to produce the given bias factor. The shaded region represents a pointwise confidence band.
Alternatively, produces distribution plots (\code{type="dist"}) for a specific bias factor showing the observed and
true distributions of RRs with a red line marking exp(\code{q}).
}
\details{
This function calls \code{confounded_meta} to get the point estimate and confidence interval at each value of the bias factor. See \code{?confounded_meta} for details.

Note that \code{Bmin} and \code{Bmax} are specified on the log scale for consistency with the \code{muB} argument and with the function \code{confounded_meta}, whereas \code{breaks.x1} and \code{breaks.x2} are specified on the relative risk scale to facilitate adjustments to the plot appearance.
}
\examples{

##### Example 1: Calibrated Line Plots #####

# simulated dataset with exponentially distributed 
#  population effects
# we will use the calibrated method to avoid normality assumption
data(toyMeta)

# without confidence band
sens_plot( method = "calibrated",
           type="line",
           q=log(.9),
           tail = "below",
           dat = toyMeta,
           yi.name = "est",
           vi.name = "var",
           give.CI = FALSE )


# # with confidence band and a different threshold, q
# # commented out because takes a while too run
# sens_plot( method = "calibrated",
#            type="line",
#            q=0,
#            tail = "below",
#            dat = toyMeta,
#            yi.name = "est",
#            vi.name = "var",
#            give.CI = TRUE,
#            R = 300 ) # should be higher in practice


##### Example 2: Calibrated and Parametric Line Plots #####

# example dataset
d = metafor::escalc(measure="RR",
                    ai=tpos,
                    bi=tneg,
                    ci=cpos,
                    di=cneg,
                    data=metafor::dat.bcg)

# without confidence band
sens_plot( method = "calibrated",
           type="line",
           tail = "below",
           q=log(1.1),
           dat = d,
           yi.name = "yi",
           vi.name = "vi",
           give.CI = FALSE )

# # with confidence band
# # commented out because it takes a while
# # this example gives bootstrap warnings because of its small sample size
# sens_plot( method = "calibrated",
#            type="line",
#            q=log(1.1),
#            R = 500,  # should be higher in practice (e.g., 1000)
#            dat = d,
#            yi.name = "yi",
#            vi.name = "vi",
#            give.CI = TRUE )


# now with heterogeneous bias across studies (via sigB) and with confidence band
sens_plot( method = "parametric",
           type="line",
           q=log(1.1),
           yr=log(1.3),
           vyr = .05,
           vt2 = .001,
           t2=0.4,
           sigB = 0.1,
           Bmin=0,
           Bmax=log(4) )

##### Distribution Line Plot #####

# distribution plot: apparently causative
sens_plot( type="dist",
           q=log(1.1),
           muB=log(2),
           sigB = 0.1,
           yr=log(1.3),
           t2=0.4 )

# distribution plot: apparently preventive
sens_plot( type="dist",
           q=log(0.90),
           muB=log(1.5),
           sigB = 0.1,
           yr=log(0.7),
           t2=0.2 )
}
\references{
Mathur MB & VanderWeele TJ (2020a). Sensitivity analysis for unmeasured confounding in meta-analyses. \emph{Journal of the American Statistical Association}.

Mathur MB & VanderWeele TJ (2020b). Robust metrics and sensitivity analyses for meta-analyses of heterogeneous effects. \emph{Epidemiology}.

Wang C-C & Lee W-C (2019). A simple method to estimate prediction intervals and
predictive distributions: Summarizing meta-analyses
beyond means and confidence intervals. \emph{Research Synthesis Methods}.
}
\keyword{confounding}
\keyword{meta-analysis}
\keyword{sensitivity}
