% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelFunctions.R
\name{meiosisMatrix}
\alias{meiosisMatrix}
\title{Meiosis matrix generation}
\usage{
meiosisMatrix(genomeObj)
}
\arguments{
\item{genomeObj}{a \code{Genome} object}
}
\value{
A meiosis matrix (probability matrix that associates to each
genotype in a row the probability of producing each of the possible
haplotypes).
}
\description{
Generation of the meiosis matrix associated to a \code{Genome} object.
}
\details{
A meiosis matrix is a matrix where the number of rows is equal to the number
of genotypes and the number of columns to the number of haplotypes. It is a
matrix that allows to pass from parental genotypes to gametic haplotypes
by meiosis. It is a probability matrix in that the sum of the values in each
row is equal to 1. For a given genotype, the row associated with it
describes the probabilistic proportions that lead by meiosis to the
production of the other genotypes (and of itself if there are no mutations).
}
\author{
Ehouarn Le Faou
}
