% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.cbind.R
\name{eco.cbind}
\alias{eco.cbind}
\title{Combining ecogen object by column}
\usage{
eco.cbind(eco1, eco2, ..., missing = c("0", "MEAN", "NA"))
}
\arguments{
\item{eco1}{Object of class "ecogen".}

\item{eco2}{Object of class "ecogen".}

\item{...}{Other "ecogen" objects to combine and the specification of 
the data frames to combine. 
Can be any of the following(s): P","G", "E", "S", "C", or "ALL" (default). 
If a "G" data frame is provided, the program also generates 
the A slot coding the missing data as "0" in default option (see the
argument "missing").
The XY slot is generated automatically if present.}

\item{missing}{Missing data manipulation.
It can take three values ("0" ,"NA" or "MEAN"- i.e, the mean frequency
of the corresponding allele). 
Missing elements are coded as 0 in the default option.}
}
\description{
Combining ecogen object by column
}
\examples{

\dontrun{

data(eco.test)
eco.example <- eco.cbind(eco,eco,"ALL")
eco.example
eco.example2 <- eco.cbind(eco, eco,"P", "G", missing="NA")
eco.example2

}

}
\author{
Leandro Roser \email{learoser@gmail.com}
}
