% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.rankplot.R
\name{eco.rankplot}
\alias{eco.rankplot}
\alias{eco.rankplot,eco.lsa,missing,missing-method}
\alias{eco.rankplot,eco.lsa-method}
\alias{eco.rankplot,numeric,dataframeORmatrix,missing-method}
\alias{eco.rankplot,numeric-method}
\alias{eco.rankplot,factor,dataframeORmatrix,missing-method}
\alias{eco.rankplot,factor-method}
\title{Rankplot graphs}
\usage{
eco.rankplot(
  input,
  XY,
  xlabel = NULL,
  ylabel = NULL,
  title = NULL,
  legendlabel = NULL,
  background = c("grey", "white"),
  ...
)

\S4method{eco.rankplot}{eco.lsa,missing,missing}(
  input,
  XY,
  xlabel,
  ylabel,
  title,
  legendlabel,
  background = c("grey", "white"),
  significant = TRUE,
  rescaled = FALSE,
  ns = NULL,
  interactivePlot = TRUE
)

\S4method{eco.rankplot}{numeric,dataframeORmatrix,missing}(
  input,
  XY,
  xlabel,
  ylabel,
  title,
  legendlabel,
  background = c("grey", "white"),
  interactivePlot = TRUE
)

\S4method{eco.rankplot}{factor,dataframeORmatrix,missing}(
  input,
  XY,
  xlabel,
  ylabel,
  title,
  legendlabel,
  background = c("grey", "white"),
  interactivePlot = TRUE
)
}
\arguments{
\item{input}{Numeric/factor variable.}

\item{XY}{Data frame or matrix with X-Y coordinates.}

\item{xlabel}{Optional label for x axis.}

\item{ylabel}{Optional label for y axis.}

\item{title}{Optional title label.}

\item{legendlabel}{Optional legend label.}

\item{background}{Background color ("grey" or "white")-}

\item{...}{Additional elements to the generic.}

\item{significant}{Should only the individuals with significant 
result be colored?. This argument can be used with \code{\link{eco.lsa}} results. 
Default TRUE}

\item{rescaled}{rescale values to [-1, 1] range?}

\item{ns}{Color for non significant individuals, when significant = TRUE.
This argument can be used with \code{\link{eco.lsa}} results.}

\item{interactivePlot}{Show an interactive plot via plotly? (default: TRUE)}
}
\description{
This function generates a plot for a numeric or
factor variable. A data frame/matrix with XY coordinates is required.
The X and Y axes in the plot correspond 
to the rank of the X and Y coordinates, respectively.
}
\examples{
\dontrun{
data(eco3)

# The data set eco3 has 50 points in two sites, 
# but points are not visible in a usual X-Y plot, 
# due to the small distance among them in relation to the large
# distance between sites

var <- eco3[["P"]][,1]
plot(eco3[["XY"]], col = var)
x <- sample(1:100, 30)
y <- sample(1:100, 30)

# in a rankplot graph, the inter-individual distances are
# reduced to a single scale
rankeco3 <- eco.rankplot(var, eco3[["XY"]])
rankeco3

# the rankplot method supports the use of ggplot2 syntax with ggplot2 graphs
require(ggplot2)
rankeco3 <- eco.rankplot(var, eco3[["XY"]], interactivePlot = FALSE)
rankeco3 <- rankeco3 + theme_bw() + theme(legend.position="none")
rankeco3
}

}
\author{
Leandro Roser \email{learoser@gmail.com}
}
