% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.alfreq.R
\name{eco.alfreq}
\alias{eco.alfreq}
\title{Allelic frequency histograms for an ecogen genetic data frame}
\usage{
eco.alfreq(eco, grp = NULL)
}
\arguments{
\item{eco}{Object of class "ecogen".}

\item{grp}{Optional factor (column of the S slot) for plots by group.}
}
\description{
This program computes the frequency of each allele and plots 
a histogram for the number of alleles with a given frequency. 
The distribution is expected to be L-shaped under mutation-drift equilibrium.
When a factor is given, the program plots a histogram for each group.
}
\examples{

\dontrun{

data(eco.test)
eco.alfreq(eco)
eco.alfreq(eco, "pop")

}

}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}
\references{
Luikart G., F. Allendorf, F. Cornuet, and W. Sherwin. 1998. 
Distortion of allele frequency distributions provides a test for recent 
population bottlenecks. Journal of Heredity, 89: 238-247.
}

