% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/algorithms.R
\name{size_gamma}
\alias{size_gamma}
\title{SizeGamma Size Overlap Randomization Algorithm}
\usage{
size_gamma(speciesData = rnorm(50, mean = 100, sd = 1))
}
\arguments{
\item{speciesData}{a vector of body sizes or other trait measurements of
species. All values must be positive real numbers.}
}
\value{
Returns a vector of simulated body sizes as the same length as speciesData.
}
\description{
Function to generate a random distribution of body sizes by
drawing from a gamma distribution. Shape and rate parameters of the gamma
are estimated from the empirical data.
}
\note{
The shape and rate parameters are estimated from the real data using
the maximum likelihood estimators generated from the fitdr function in
the MASS library. The flexible gamma distribution can be fit to a variety of
normal, log-normal, and exponential distributions that are typical for trait
data measured on a continuous non-negative scale.
}
\examples{
obsOverlap <- size_gamma(speciesData=rnorm(50,mean=100,sd=1))
}
\seealso{
\code{\link{fitdistr}} in the MASS library.
}

