% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showPlausibleValues.R
\name{showPlausibleValues}
\alias{showPlausibleValues}
\title{Print a summary of the subject scale or subscale and the associated variables for their plausible values.}
\usage{
showPlausibleValues(data, verbose = FALSE)
}
\arguments{
\item{data}{an \code{edsurvey.data.frame} or \code{light.edsurvey.data.frame}.}

\item{verbose}{logical. Set to \code{TRUE} to get the variable names for plausible values.}
}
\value{
A pasted statement of the set of variable names for the plausible values.
}
\description{
Print out a summary of the subject scale or subscale and the associated variables for their
             plausible values on an \code{edsurvey.data.frame} or \code{light.edsurvey.data.frame}.
}
\examples{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))

# show the plasusible values
showPlausibleValues(data=sdf, verbose=TRUE)
}
\author{
Michael Lee and Paul Bailey
}
