% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.edsurvey.data.frame.R
\docType{methods}
\name{subset.edsurvey.data.frame}
\alias{subset.edsurvey.data.frame}
\alias{subset,edsurvey.data.frame-method}
\alias{subset,light.edsurvey.data.frame-method}
\title{Subset the rows of an \code{edsurvey.data.frame}.}
\usage{
\method{subset}{edsurvey.data.frame}(x, subset, ..., inside = FALSE)

\S4method{subset}{edsurvey.data.frame}(x, subset, ..., inside = FALSE)

\S4method{subset}{light.edsurvey.data.frame}(x, subset, ..., inside = FALSE)
}
\arguments{
\item{x}{an \code{edsurvey.data.frame}.}

\item{subset}{a condition, written out similar to \code{summary}; when
\code{inside=TRUE}, parsed text.}

\item{...}{not used. Included only for compatability.}

\item{inside}{set to \code{TRUE} to prevent \code{substitute} 
from being called on the \code{subset} argument, see Details.}
}
\value{
An object of the same class as \code{x} (an \code{edsurvey.data.frame} or
        a \code{light.edsurvey.data.frame}).
}
\description{
Return a new \code{edsurvey.data.frame} which, when passed to
             \code{getData}, returns only a subset of the data.
}
\details{
Note that any variables defined in condition that are not references
to column names on the
\code{edsurvey.data.frame} and are part of the environment where
\code{subset.edsurvey.data.frame} was called will be evaluated
in the environment from which \code{subset.edsurvey.data.frame} was called.
Similar to the difficulty of using subset within a function call because of
the call to substitute on condition,
this function is difficult to use (with inside set to the default value of
\code{FALSE}) inside another function call.
See examples for how to call this function from within another function.
}
\examples{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))

# table to compare to subsequent tables with subsets:
edsurveyTable(composite ~ dsex, data=sdf, returnMeans=FALSE, returnSepct=FALSE)

# subset to just males
newsdf <-  subset(x=sdf, subset= dsex == "Male") 
# table of dsex after subset
edsurveyTable(composite ~ dsex, data=newsdf, returnMeans=FALSE, returnSepct=FALSE)

# Variable names that are not in the sdf get resolved in the parent frame.
# Practically, that means that the following two subset 
# calls sdfM1 and sdfM2 do the same thing:
male_var <- "Male"
sdfM1 <- subset(x=sdf, subset= dsex == male_var)
sdfM2 <- subset(x=sdf, subset= dsex == "Male")
table(getData(data=sdfM1, varnames="dsex"))
table(getData(data=sdfM2, varnames="dsex"))

# variable can also be resolved as members of lists
genders <- c("Male", "Female","not a sex level")
sdfn <- subset(x=sdf, subset= dsex == genders[2]) 
table(getData(data=sdfn, varnames="dsex"))

# variables can also be subset using \%in\%
sdfM3 <- subset(x=sdf, subset= dsex \%in\% c("Male", "not a sex level")) 
table(getData(data=sdfM3, varnames="dsex"))

# if you need to call a name on the sdf dynamically, you can use as.name
dsex_standin <- as.name("dsex")
sdfM4 <- subset(x=sdf, subset= dsex_standin == "Male")
table(getData(data=sdfM4, varnames="dsex"))


# Here is an example of how one might want to call
# subset from within a function or loop.
# First,define a few variables to use dynamically
rhs_vars <- c("dsex", "b017451")
lvls <- c("Male", "Female")

# create a parsed condition
cond <- parse(text=paste0(rhs_vars[1], " == \\"",lvls[1],"\\""))[[1]]

# when inside=TRUE a parsed condition can be passed to subset
dsdf <- subset(x=sdf, subset=cond, inside=TRUE)

# check the result
table(getData(data=dsdf, varnames="dsex"))
}
\references{
Wickham, H. (2014). \emph{Advanced R}. Boca Raton, FL: Chapman & Hall/CRC.
}
\author{
Paul Bailey
}
