% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadPIRLS.R
\name{downloadPIRLS}
\alias{downloadPIRLS}
\title{Download and Unzip PIRLS Files}
\usage{
downloadPIRLS(years = c(2001, 2006, 2011), root, cache = FALSE)
}
\arguments{
\item{years}{an integer vector of the assessment years to download. Valid years are 2001, 2006, and 2011.}

\item{root}{a character string indicating the directory where the PIRLS
data should be stored. Note that files are placed in a
subdirectory named PIRLS[year].}

\item{cache}{a logical value set to process and cache the text (.txt) version of files.
This takes a very long time but saves time for future uses of 
the data.  Default value is \code{FALSE}.}
}
\description{
Uses an Internet connection to download PIRLS data. 
             Data come from \href{https://timssandpirls.bc.edu/}{timssandpirls.bc.edu} zip files. This
             function works for 2001, 2006, and 2011 data.
}
\examples{
\dontrun{
  # root argument will vary by operating system conventions
  downloadPIRLS(year=c(2006, 2011), root = "C:/")
  
  # cache=TRUE will download then process the datafiles
  downloadPIRLS(year=2011, root = "C:/", cache = TRUE)
}
}
\seealso{
\code{\link{readPIRLS}}
}
\author{
Tom Fink
}
