% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_ePIRLS.R
\name{download_ePIRLS}
\alias{download_ePIRLS}
\title{Download and Unzip ePIRLS Files}
\usage{
download_ePIRLS(root, years = c(2016), cache = FALSE, verbose = TRUE)
}
\arguments{
\item{root}{a character string indicating the directory where the ePIRLS
data should be stored. Files are placed in a
subdirectory named ePIRLS/[year].}

\item{years}{an integer vector of the assessment years to download. Valid year is 2016 only.}

\item{cache}{a logical value set to process and cache the text (.txt) version of files.
This takes a very long time but saves time for future uses of 
the data. Default value is \code{FALSE}.}

\item{verbose}{a logical value to either print or suppress status message output.
The default value is \code{TRUE}.}
}
\description{
Uses an Internet connection to download ePIRLS data. 
             Data come from \href{https://timssandpirls.bc.edu/}{timssandpirls.bc.edu} zip files. This
             function works for 2016 data.
}
\examples{
\dontrun{
# root argument will vary by operating system conventions
download_ePIRLS(years=2016, root = "C:/")

# cache=TRUE will download then process the datafiles
download_ePIRLS(years=2016, root = "C:/", cache = TRUE)

# set verbose=FALSE for silent output
# if year not specified, download all years
download_ePIRLS(root="C:/", verbose = FALSE)
}
}
\seealso{
\code{\link{read_ePIRLS}}
}
\author{
Tom Fink
}
