% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.light.edsurvey.data.frame.R
\name{merge}
\alias{merge}
\alias{merge.light.edsurvey.data.frame}
\title{EdSurvey Merge}
\usage{
\method{merge}{light.edsurvey.data.frame}(x, y, ...)
}
\arguments{
\item{x}{a \code{light.edsurvey.data.frame}. The attributes of the resulting \code{light.edsurvey.data.frame} 
are taken from \code{x}.}

\item{y}{either a \code{light.edsurvey.data.frame} or a \code{data.frame}}

\item{...}{arguments to be passed to \ifelse{latex}{\code{merge}}{\code{\link[base]{merge}}}}
}
\value{
a \code{light.edsurvey.data.frame} with the same attributes as \code{x}
}
\description{
Takes a \code{data.frame} or a \code{light.edsurvey.data.frame} and merges with a \code{light.edsurvey.data.frame}.
}
\examples{
# read in NAEP primer data
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))
lsdf <- getData(data=sdf, varnames=c("dsex", "b017451"), addAttributes = TRUE)
df <- data.frame(dsex = c("Male","Female"), dsex2 = c("Boy","Girl"))

# merging a light.edsurvey.data.frame with a data.frame
# returns a light.edsurvey.data.frame object
merged_lsdf <- merge(lsdf,df, by = "dsex")
class(merged_lsdf) #  "light.edsurvey.data.frame" "data.frame"
head(merged_lsdf) # shows merge results

# merging behaves similarly to base::merge
df2 <- data.frame(dsex = c("Male","Female"), b017451 = c(1,2))
merged_lsdf2 <- merge(lsdf,df2, by = "dsex")
names(merged_lsdf2) # "dsex"      "b017451.x" "b017451.y"
head(merged_lsdf2) # shows merge results

}
\seealso{
\ifelse{latex}{\code{merge}}{\code{\link[base]{merge}}}
}
\author{
Trang Nguyen
}
