% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readBPS_1994.R
\name{readBPS_1994}
\alias{readBPS_1994}
\title{Beginning Postsecondary Students (BPS:90/94) Data}
\usage{
readBPS_1994(
  b94DAT_Filepath,
  masterTxtFilepath,
  forceReread = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{b94DAT_Filepath}{a character value of the file path to the student BPS:90/94 (.dat) file}

\item{masterTxtFilepath}{a character value of the file path to the \code{master.txt} file contained within the electronic codebook directory}

\item{forceReread}{a logical value to force rereading of all processed data.
The default value of \code{FALSE} will speed up the read function by using existing read-in data already processed.}

\item{verbose}{a logical value that will determine if you want verbose output while the \code{readHSB_Sophomore} function is running to indicate processing progress.
The default value is \code{TRUE}.}
}
\value{
An \code{edsurvey.data.frame} for the BPS longitudinal dataset.
}
\description{
Opens a connection to a BPS 1990 to 1994 cohort data file and
             returns an \code{edsurvey.data.frame} with 
             information about the file and data.
}
\details{
Reads in the student BPS 1990 to 1994 cohort data file to an \code{edsurvey.data.frame}.
}
\examples{
\dontrun{
setwd("C:/BPS1994/")

datFP <- file.path(getwd(), "BPS94", "STUDENT.DAT")
mstFP <- file.path(getwd(), "ECBW", "BP4", "MASTER.TXT")

#with verbose output as default
bps94 <- readBPS_1994(datFP, mstFP)

#silent output
bps94 <- readBPS_1994(datFP, mstFP, verbose=FALSE)

#force data cache update
bps94 <- readBPS_1994(datFP, mstFP, forceReread = TRUE)
}
}
\seealso{
\code{\link{readBB_2001}}, \code{\link{readNAEP}}, and \code{\link{getData}}
}
\author{
Sun-joo Lee
}
