% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readBB_2003.R
\name{readBB_2003}
\alias{readBB_2003}
\title{Connect to B&B 1993--2003 Data}
\usage{
readBB_2003(
  b03DAS_Filepath,
  b03WEIGHT_FilePath,
  masterTxtFilepath,
  forceReread = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{b03DAS_Filepath}{a character value to the main study-derived analytical data file (\code{B03DAS.dat}).  Located within the \code{ECBW/Data} Folder.}

\item{b03WEIGHT_FilePath}{a character value to the study weight data file (\code{B03WEIGHT.dat}). Located within the \code{ECBW/Data} Folder.}

\item{masterTxtFilepath}{a character value of the master format file (\code{master.txt}) that contains the metadata 
for the \code{b03DAS_Filepath} and \code{b03WEIGHT_FilePath}.  Located in the \code{ECBW} folder.}

\item{forceReread}{a logical value to force rereading of all processed data.
The default value of \code{FALSE} will speed up the read function by using existing read-in data already processed.}

\item{verbose}{a logical value that will determine if you want verbose output while the \code{readBB_2003} function is running to indicate processing progress.
The default value is \code{TRUE}.}
}
\value{
an \code{edsurvey.data.frame} for the B&B 1993--2003 longitudinal dataset.
}
\description{
Opens a connection to a Baccalaureate & Beyond 1993--2003 data file and
             returns an \code{edsurvey.data.frame} with 
             information about the file and data.
}
\details{
Reads in the specified \code{masterTxtFilepath} file to parse the \code{b03DAS_Filepath} and \code{b03WEIGHT_FilePath} files 
         for the B&B 1993--2003 longitudinal survey to an \code{edsurvey.data.frame}.
         The two created cached data files will be saved in the same directory and filename as the \code{b03DAS_Filepath} file,
         having new file extensions of .txt and .meta.
}
\examples{
\dontrun{
setwd("C:/B&B2003/ecbw/B03")

dasFP <- file.path(getwd(), "Data", "B03DAS.dat")
wgtFP <- file.path(getwd(), "Data", "B03WEIGHT.dat")
mstFP <- file.path(getwd(), "master.txt")

# with verbose output as default
bb2003 <- readBB_2003(dasFP, wgtFP, mstFP)

# silent output
bb2003 <- readBB_2003(dasFP, wgtFP, mstFP, verbose=FALSE)

# force data cache update
bb2003 <- readBB_2003(dasFP, wgtFP, mstFP, forceReread = TRUE)
}
}
\seealso{
\code{\link{readECLS_K2011}}, \code{\link{readNAEP}}, and \code{\link{getData}}
}
\author{
Tom Fink
}
