% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSSOCS.R
\name{readSSOCS}
\alias{readSSOCS}
\title{Connect to School Survey on Crime and Safety Data}
\usage{
readSSOCS(sasDataFiles, years, forceReread = FALSE, verbose = TRUE)
}
\arguments{
\item{sasDataFiles}{a character vector to the full SAS (*.sas7bdat) data file path(s) you wish to read. 
If multiple paths are specified as a vector, it will return an \code{edsurvey.data.frame.list}.}

\item{years}{an integer vector of the year associated with the index position of the \code{sasDataFile} data file vector.
The year is required to correctly determine required metadata about the file.
Valid year values are as follows: 2000 (1999--2000), 2004 (2003--2004), 2006 (2005--2006), 2008 (2007--2008), 
2010 (2009--2010), 2016 (2015--2016), 2018 (2017--2018).}

\item{forceReread}{a logical value to force rereading of all processed data.
The default value of \code{FALSE} will speed up the \code{readSSOCS} function by using existing read-in data already processed.}

\item{verbose}{a logical value to either print or suppress status message output.
The default value is \code{TRUE}.}
}
\value{
An \code{edsurvey.data.frame} if one data file is specified or an \code{edsurvey.data.frame.list} if multiple files are specified in the \code{sasDataFiles} parameter.
}
\description{
Opens a connection to a School Survey on Crime and Safety (SSOCS) data file and
             returns an \code{edsurvey.data.frame}, or an \code{edsurvey.data.frame.list} if multiple files specified,
             with information about the file(s) and data.
}
\details{
Reads in the unzipped files downloaded from the SSOCS Data Products website in SAS format.  Other sources of SSOCS data, such as
restricted-use data or other websites, may require additional conversion steps to generate the required SAS format.
}
\note{
For the \code{readSSOCS} function, value label information is stored and retrieved automatically within the \code{EdSurvey} package (based on the year parameter), 
      as the SAS files contain only raw data values.
}
\examples{
\dontrun{
#download SSOCS data for years 2016 and 2018 
downloadSSOCS(years = c(2016, 2018))

rootPath <- "~/"# may need to change this 
#get SAS *.sas7bdat file paths of all SSOCS files for 2016 and 2018
filesToImport <- list.files(path = file.path(rootPath, "SSOCS", c(2016, 2018)),
                            pattern="\\\\.sas7bdat$",
                            full.names = TRUE)
  
#import all files to edsurvey.data.frame.list object
esdfList <- readSSOCS(sasDataFiles = filesToImport,
                      years = c(2016, 2018),
                      forceReread = FALSE,
                      verbose = TRUE)

#reading in the 2018 to an edsurvey.data.frame object
esdf <- readSSOCS(sasDataFiles = file.path(rootPath, "SSOCS/2018/pu_ssocs18.sas7bdat"),
                  years = 2018,
                  forceReread = FALSE,
                  verbose = TRUE)
  
#search for variables in the edsurvey.data.frame containing the word 'bully'
searchSDF("bully", esdf)
}
}
\seealso{
\code{\link{downloadSSOCS}}, and \code{\link{getData}}
}
\author{
Tom Fink
}
