% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect.stars.vglm.R
\name{effectstars.vglm}
\alias{effectstars.vglm}
\title{Plot effect stars for vglm objects.}
\usage{
\method{effectstars}{vglm}(x, p.values = FALSE, symmetric = TRUE,
  plot.parallel = FALSE, ...)
}
\arguments{
\item{x}{A \code{\link[VGAM]{vglm}}-object.}

\item{p.values}{Should the p-values of the single coefficients be included in the labels? Default 
is \code{FALSE}.}

\item{symmetric}{Should the parameters be transformed to parameters with symmetric (sum-to-zero) 
side constraints instead of using reference levels. Default is \code{TRUE} for 
\code{\link[VGAM]{multinomial}}-models. If the \code{\link[VGAM]{multinomial}}-model 
contains object-specific covariates (\code{xij} argument from \code{\link[VGAM]{vglm.control}}) symmetric side 
constraints are not possible. In ordinal response models, 
no side constraints are needed and the option is obsolete.}

\item{plot.parallel}{Should parallel parameters (equal over all response categories) be 
represented by effect stars. Default is \code{FALSE}.}

\item{...}{further arguments for generic function \code{\link{effectstars}}.}
}
\description{
Plots effect stars for \code{\link[VGAM]{vglm}}-objects. In particular, the method
works for multinomial logit models created by family \code{\link[VGAM]{multinomial}} and for 
models with ordinal response like \code{\link[VGAM]{sratio}}, \code{\link[VGAM]{cratio}},
\code{\link[VGAM]{cumulative}} or \code{\link[VGAM]{acat}}. \cr

For more details on plotting effect stars see \code{\link{effectstars}}.
}
\examples{
\dontrun{
############################################
### Examples for multinomial logit model
############################################

### German election data
data(election) 
library(VGAM)
m_elect <- vglm(Partychoice ~ Gender + West + Age + Union + Highschool + Unemployment
+ Pol.Interest + Democracy + Religion, family = multinomial(), data = election)

effectstars(m_elect)

# include p.values
effectstars(m_elect, p.values = TRUE)

### German election data with category-specific covariates

data(election)
election[,13:16] <- election[,13:16] - election[,12]
election[,18:21] <- election[,18:21] - election[,17]
election[,23:26] <- election[,23:26] - election[,22]
election[,28:31] <- election[,28:31] - election[,27]

election$Social <- election$Social_SPD
election$Immigration <- election$Immigration_SPD
election$Nuclear <- election$Nuclear_SPD
election$Left_Right <- election$Left_Right_SPD

m.all <- vglm(Partychoice ~ Social + Immigration + Nuclear + Left_Right + Age + 
                Religion + Democracy + Pol.Interest + Unemployment + Highschool + Union + West + 
                Gender, data = election, 
                family = multinomial(parallel = TRUE~-1 + Social + Immigration + 
                Nuclear + Left_Right, refLevel = 1),
              xij = list(Social ~ Social_SPD + Social_FDP + Social_Greens + Social_Left,
                         Immigration ~ Immigration_SPD + Immigration_FDP + 
                         Immigration_Greens + Immigration_Left,
                         Nuclear ~ Nuclear_SPD + Nuclear_FDP + 
                         Nuclear_Greens + Nuclear_Left,
                         Left_Right ~ Left_Right_SPD + Left_Right_FDP + 
                         Left_Right_Greens + Left_Right_Left),
              form2 = ~Social + Immigration + Nuclear + Left_Right + Age + 
                Religion + Democracy + Pol.Interest + Unemployment + Highschool + Union + West + 
                Gender + Social_SPD + Social_FDP + Social_Greens + Social_Left +
                Immigration_SPD + Immigration_FDP + Immigration_Greens + Immigration_Left +
                Nuclear_SPD + Nuclear_FDP + Nuclear_Greens + Nuclear_Left +
                Left_Right_SPD + Left_Right_FDP + Left_Right_Greens + Left_Right_Left
)

effectstars(m.all, symmetric = FALSE, p.values = TRUE)
summary(m.all)


### Chilean plebiscite data
data(plebiscite)
m_chile <- vglm(Vote ~ ., family = multinomial(), data = plebiscite)
effectstars(m_chile)

# choose fixed circle sizes and use reference category instead of symmetric side constraints
effectstars(m_chile, symmetric = FALSE, fixed = TRUE)

############################################
### Examples for ordinal data
############################################

### Munich insolvency data
data(insolvency)
insolvency$Age <- scale(insolvency$Age)

my_formula <- Insolvency ~ Age + Gender

m_acat <- vglm(my_formula, data = insolvency,family = acat())
m_cratio <- vglm(my_formula, data = insolvency,family = cratio())
m_sratio <- vglm(my_formula, data = insolvency,family = sratio())
m_cumulative <- vglm(my_formula, data = insolvency,family = cumulative())

summary(m_acat)
effectstars(m_acat, p.values = TRUE)

summary(m_cratio)
effectstars(m_cratio, p.values = TRUE)

summary(m_sratio)
effectstars(m_sratio, p.values = TRUE)

summary(m_cumulative)
effectstars(m_cumulative, p.values = TRUE)
}
}
\references{
Tutz, G. and Schauberger, G. (2013): \emph{Visualization of Categorical Response Models -
from Data Glyphs to Parameter Glyphs}, Journal of Computational and Graphical Statistics 22(1), 156--177.
\cr \cr  Gerhard Tutz (2012): \emph{Regression for Categorical Data}, Cambridge University Press
}
\seealso{
\code{\link{effectstars}} \code{\link{effectstars.DIFlasso}}
}
\author{
Gunther Schauberger \cr
\email{g.schauberger@tum.de} \cr \cr
\email{gunther@stat.uni-muenchen.de} \cr \cr
\url{https://www.researchgate.net/profile/Gunther_Schauberger2}\cr \cr
\url{http://www.semsto.statistik.uni-muenchen.de/personen/doktoranden/schauberger/index.html}
}
