% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vario.reg.prep.function.R
\name{vario.reg.prep}
\alias{vario.reg.prep}
\title{Adjustment for covariates before semi-variogram model fitting}
\usage{
vario.reg.prep(reg, data = NULL)
}
\arguments{
\item{reg}{An object of class 'lm' obtained as result of a linear regression using the function
\code{lm} from the package \code{stats} or an object of class 'lmerMod' obtained as
result of a linear mixed model regression using the function
\code{lmer} from the package \code{lme4}.}

\item{data}{Only needed if the data argument within the regression function \code{lm}/\code{lmer} is not provided:
A data frame containing the geo-coded dataset containing
the Cartesian x- and y-coordinates in the first and second column,
the outcome of interest in the third column and
all covariates used for the regression in further columns.}
}
\value{
A data frame with three columns:
\item{x}{x-coordinate in the first column.}
\item{y}{y-coordinate in the second column.}
\item{adj}{Studentized residuals to be used as new variable adjusted for covariates.}
}
\description{
Adjustment for covariates provides the option to eliminate non-spatial effects
on the variable of interest.
Given a linear regression output of class 'lm' or 'lmerMod'
with the attribute of interest as dependent variable,
the function provides a dataset containing the coordinates of the original observations
and the studentized residuals of the regression model.
}
\details{
The adjusted outcome is defined as the student residuals
of the linear or linear mixed regression model. They are calculated using the \code{rstudent} function
from package \code{stats}.
In case of a mixed model, the adjusted variable vector resembles the conditional studentized residuals.

The geo-coded dataset used for the regression is extracted from the current environment. In order to work,
the dataset has to be loaded into the environment prior to the use of \code{vario.reg.prep}.

If the data argument was specified within the regression function \code{lm/lmer},
\code{vario.reg.prep} automatically extracts the name of the dataset used for regression and calls
it from the current environment.
Otherwise, the dataset has to be provided manually as input argument within \code{vario.reg.prep}.
}
\examples{
## Example 1
head(birth) #geo-coded dataset
hist(birth$birthweight) # attribute of interest

# Linear regression model
mod1 = lm(birthweight ~ primiparous + datediff + bmi
+ inc, data = birth)
summary(mod1)
data.adj1 = vario.reg.prep(mod1)

head(data.adj1)
hist(data.adj1$adj) # adjusted attribute of interest
# The data frame can be used as input for the vario.mod function.


## Example 2
# No data argument provided within lm (not recommended, but possible):
mod2 = lm(birth$birthweight ~ birth$primiparous + birth$datediff + birth$bmi
+ birth$inc)
summary(mod2)
# In this case, make sure to provide the data argument here:
data.adj2 = vario.reg.prep(reg = mod2, data = birth)


if (requireNamespace("lme4", quietly = TRUE)) {
## Example 3
# Linear mixed regression model
mod3 = lme4::lmer(birthweight ~ primiparous + datediff
                + bmi + (1|inc), data = birth)
summary(mod3)
data.adj3 = vario.reg.prep(mod3)


## Example 4
# Data argument within lmer not provided (not recommended, but possible):
mod4 = lme4::lmer(birth$birthweight ~ birth$primiparous + birth$datediff
            + birth$bmi + (1|birth$inc))
summary(mod4)
# In this case, make sure to provide the data argument here:
data.adj4 = vario.reg.prep(reg = mod4, data = birth)
}

}
\seealso{
\code{lm} in the \code{stats} package for information on the fitting of a linear regression model;

          \code{lmer} in the \code{lme4} package for information on the fitting of a linear mixed regression model;

          \code{rstudent} in the \code{stats} package for information on how the attribute of interest is
          adjusted for covariates.
}
