% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EigenR.R
\name{Eigen_Hessenberg}
\alias{Eigen_Hessenberg}
\title{Hessenberg decomposition}
\usage{
Eigen_Hessenberg(M)
}
\arguments{
\item{M}{real or complex square matrix}
}
\value{
A list with the \code{H} and \code{Q} matrices.
}
\description{
Hessenberg decomposition of a square matrix.
}
\details{
See \href{https://eigen.tuxfamily.org/dox/classEigen_1_1HessenbergDecomposition.html}{Eigen::HessenbergDecomposition}.
}
\examples{
library(EigenR)
M <- cbind(c(3, 2i, 1+3i), c(1, 1i, 1), c(5, 0, -2i))
Eigen_Hessenberg(M)
}
