% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecological-inference.R
\docType{class}
\name{EcologicalInferenceProcessor}
\alias{EcologicalInferenceProcessor}
\title{EcologicalInferenceProcessor}
\description{
EcologicalInferenceProcessor

EcologicalInferenceProcessor
}
\examples{
library(ElectionsLATAM)
library(readr)
costa.rica.ein.path <- file.path(getPackageDir(), "costa-rica")
ecological.inference.calvo <- EcologicalInferenceStrategyCalvoEtAl$new()
costa.rica.ein <-
  EcologicalInferenceProcessor$new(
    ecological.inference.strategy = ecological.inference.calvo,
    election.name = "2022-costa-rica-general-ballotage-n4",
    scenario = "final",
    data.input.path = costa.rica.ein.path,
    input.file = "2021-generales_pivot_candidatos_n4.csv",
    location.fields = c("id_unidad"),
    votes.field = "votos",
    # potential.votes.field = "habilitados",
    ignore.fields = "habilitados",
    col.types = cols(
      .default = col_number(),
      id_unidad = col_character()
    )
  )
dummy <- costa.rica.ein$loadInputPivotCandidatos()
costa.rica.ein$output.election <- readr::read_delim(
  file.path(
    costa.rica.ein.path,
    paste("2022-ballotage_pivot_candidatos_n4.csv", sep = "_")
  ),
  delim = ";",
  col_types = cols(
    .default = col_double(),
    id_unidad = col_character()
  )
)
costa.rica.ein$runScenario(include.blancos = TRUE, include.ausentes = TRUE)

}
\author{
ken4rab
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{EcologicalInferenceProcessor$new()}}
\item \href{#method-wallTime}{\code{EcologicalInferenceProcessor$wallTime()}}
\item \href{#method-generateOutput}{\code{EcologicalInferenceProcessor$generateOutput()}}
\item \href{#method-loadInputPivotCandidatos}{\code{EcologicalInferenceProcessor$loadInputPivotCandidatos()}}
\item \href{#method-generateNormalizedOutput}{\code{EcologicalInferenceProcessor$generateNormalizedOutput()}}
\item \href{#method-makeSankeyDiagram}{\code{EcologicalInferenceProcessor$makeSankeyDiagram()}}
\item \href{#method-getFilename}{\code{EcologicalInferenceProcessor$getFilename()}}
\item \href{#method-generateOutputJSON}{\code{EcologicalInferenceProcessor$generateOutputJSON()}}
\item \href{#method-getBetab}{\code{EcologicalInferenceProcessor$getBetab()}}
\item \href{#method-exportBetab}{\code{EcologicalInferenceProcessor$exportBetab()}}
\item \href{#method-convertShares2Votes}{\code{EcologicalInferenceProcessor$convertShares2Votes()}}
\item \href{#method-convertVotes2Shares}{\code{EcologicalInferenceProcessor$convertVotes2Shares()}}
\item \href{#method-getSharesFields}{\code{EcologicalInferenceProcessor$getSharesFields()}}
\item \href{#method-fixLocationsAvailable}{\code{EcologicalInferenceProcessor$fixLocationsAvailable()}}
\item \href{#method-fixEmpty}{\code{EcologicalInferenceProcessor$fixEmpty()}}
\item \href{#method-checkDefinitions}{\code{EcologicalInferenceProcessor$checkDefinitions()}}
\item \href{#method-runScenario}{\code{EcologicalInferenceProcessor$runScenario()}}
\item \href{#method-showResultsSummary}{\code{EcologicalInferenceProcessor$showResultsSummary()}}
\item \href{#method-expectCompatible}{\code{EcologicalInferenceProcessor$expectCompatible()}}
\item \href{#method-clone}{\code{EcologicalInferenceProcessor$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceProcessor$new(
  election.name,
  ecological.inference.strategy,
  data.input.path,
  input.filename,
  scenario,
  location.fields,
  votes.field,
  absent.field = "ausente",
  parties.mapping = NULL,
  reverse.mapping = TRUE,
  potential.votes.field = NULL,
  ignore.fields = NULL,
  col.types = cols(.default = col_number()),
  seed = 143324
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wallTime"></a>}}
\if{latex}{\out{\hypertarget{method-wallTime}{}}}
\subsection{Method \code{wallTime()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceProcessor$wallTime(expr)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-generateOutput"></a>}}
\if{latex}{\out{\hypertarget{method-generateOutput}{}}}
\subsection{Method \code{generateOutput()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceProcessor$generateOutput()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-loadInputPivotCandidatos"></a>}}
\if{latex}{\out{\hypertarget{method-loadInputPivotCandidatos}{}}}
\subsection{Method \code{loadInputPivotCandidatos()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceProcessor$loadInputPivotCandidatos(
  input.filename = self$input.filename
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-generateNormalizedOutput"></a>}}
\if{latex}{\out{\hypertarget{method-generateNormalizedOutput}{}}}
\subsection{Method \code{generateNormalizedOutput()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceProcessor$generateNormalizedOutput(indicator = "perc")}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-makeSankeyDiagram"></a>}}
\if{latex}{\out{\hypertarget{method-makeSankeyDiagram}{}}}
\subsection{Method \code{makeSankeyDiagram()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceProcessor$makeSankeyDiagram(output.path = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getFilename"></a>}}
\if{latex}{\out{\hypertarget{method-getFilename}{}}}
\subsection{Method \code{getFilename()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceProcessor$getFilename(file.prefix, extension = "csv")}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-generateOutputJSON"></a>}}
\if{latex}{\out{\hypertarget{method-generateOutputJSON}{}}}
\subsection{Method \code{generateOutputJSON()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceProcessor$generateOutputJSON(
  output.path = NULL,
  filename = self$getFilename(paste(self$election.name, "-ein", sep = ""), extension =
    "json")
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getBetab"></a>}}
\if{latex}{\out{\hypertarget{method-getBetab}{}}}
\subsection{Method \code{getBetab()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceProcessor$getBetab()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-exportBetab"></a>}}
\if{latex}{\out{\hypertarget{method-exportBetab}{}}}
\subsection{Method \code{exportBetab()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceProcessor$exportBetab(
  output.folder = NULL,
  overwrite = FALSE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-convertShares2Votes"></a>}}
\if{latex}{\out{\hypertarget{method-convertShares2Votes}{}}}
\subsection{Method \code{convertShares2Votes()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceProcessor$convertShares2Votes(election.df)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-convertVotes2Shares"></a>}}
\if{latex}{\out{\hypertarget{method-convertVotes2Shares}{}}}
\subsection{Method \code{convertVotes2Shares()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceProcessor$convertVotes2Shares(election.df)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getSharesFields"></a>}}
\if{latex}{\out{\hypertarget{method-getSharesFields}{}}}
\subsection{Method \code{getSharesFields()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceProcessor$getSharesFields(election.fields)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fixLocationsAvailable"></a>}}
\if{latex}{\out{\hypertarget{method-fixLocationsAvailable}{}}}
\subsection{Method \code{fixLocationsAvailable()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceProcessor$fixLocationsAvailable(
  max.potential.votes.rel.dif = Inf
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fixEmpty"></a>}}
\if{latex}{\out{\hypertarget{method-fixEmpty}{}}}
\subsection{Method \code{fixEmpty()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceProcessor$fixEmpty()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-checkDefinitions"></a>}}
\if{latex}{\out{\hypertarget{method-checkDefinitions}{}}}
\subsection{Method \code{checkDefinitions()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceProcessor$checkDefinitions()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-runScenario"></a>}}
\if{latex}{\out{\hypertarget{method-runScenario}{}}}
\subsection{Method \code{runScenario()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceProcessor$runScenario(
  include.blancos = TRUE,
  include.ausentes = TRUE,
  max.potential.votes.rel.dif = Inf
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-showResultsSummary"></a>}}
\if{latex}{\out{\hypertarget{method-showResultsSummary}{}}}
\subsection{Method \code{showResultsSummary()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceProcessor$showResultsSummary(election.df, description)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-expectCompatible"></a>}}
\if{latex}{\out{\hypertarget{method-expectCompatible}{}}}
\subsection{Method \code{expectCompatible()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceProcessor$expectCompatible(
  output.table.expected,
  tolerance.rel = 0.1
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EcologicalInferenceProcessor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
