% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KTMatrixEst.R
\name{KTMatrixEst}
\alias{KTMatrixEst}
\title{Fast estimation of Kendall's tau matrix}
\usage{
KTMatrixEst(dataMatrix, blockStructure = NULL, averaging = "no")
}
\arguments{
\item{dataMatrix}{matrix of size \code{(n,d)} containing \code{n} observations
of a \code{d}-dimensional random vector.}

\item{blockStructure}{list of vectors.
Each vector corresponds to one group of variables
and contains the indexes of the variables that belongs to this group.
\code{blockStructure} must be a partition of \code{1:d},
where \code{d} is the number of columns in \code{dataMatrix}.}

\item{averaging}{type of averaging used for fast estimation.
Possible choices are \itemize{
\item \code{no}: no averaging;
\item \code{all}: averaging all Kendall's taus in each block.
\code{N} is then the number of entries in the block, i.e. the
products of both dimensions.
\item \code{diag}: averaging along diagonal blocks elements.
\code{N} is then the minimum of the block's dimensions.
\item \code{row}: averaging Kendall's tau along the smallest block side.
\code{N} is then the minimum of the block's dimensions.
}}
}
\value{
matrix with dimensions depending on \code{averaging}.
\itemize{
\item If \code{averaging = no},
the function returns a matrix of dimension \code{(n,n)}
which estimates the Kendall's tau matrix.

\item Else, the function returns a matrix of dimension
\code{(length(blockStructure) , length(blockStructure))}
giving the estimates of the Kendall's tau for each block with ones on the diagonal.

}
}
\description{
Estimate Kendall's tau matrix using averaging estimators. Under
the structural assumption that Kendall's tau matrix is block-structured
with constant values in each off-diagonal block, this function estimates
Kendall's tau matrix ``fast'', i.e. in time \code{N n log(n)},
where \code{N} is the amount of pairs that are averaged.
}
\examples{
# Estimating off-diagonal block Kendall's taus
matrixCov = matrix(c(1  , 0.5, 0.3 ,0.3,
                     0.5,   1, 0.3, 0.3,
                     0.3, 0.3,   1, 0.5,
                     0.3, 0.3, 0.5,   1), ncol = 4 , nrow = 4)
dataMatrix = mvtnorm::rmvnorm(n = 100, mean = rep(0, times = 4), sigma = matrixCov)
blockStructure = list(1:2, 3:4)
KTMatrixEst(dataMatrix = dataMatrix, blockStructure = blockStructure,
            averaging = "all")


}
\author{
Rutger van der Spek, Alexis Derumigny
}
