% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/creatematrix.R
\name{creatematrix}
\alias{creatematrix}
\title{create a dominance matrix}
\usage{
creatematrix(
  eloobject,
  daterange = NULL,
  drawmethod = "omit",
  onlyinteracting = FALSE,
  winners,
  losers,
  draw = NULL
)
}
\arguments{
\item{eloobject}{output from \code{\link{elo.seq}}}

\item{daterange}{character of length 2, date range to which the matrix should correspond (default from beginning to end of sequence)}

\item{drawmethod}{character with the following options:\cr
\code{"omit"} = undecided interactions (draws/ties) are ignored (default)\cr
\code{"0.5"} = each undecided is counted half a win for each dyad member\cr
\code{"1"} = each undecided interaction is counted twice, i.e. as win for both individuals}

\item{onlyinteracting}{logical, indicating whether all individuals that were present (default, \code{TRUE}) are shown in the matrix, or only those that were involved in an interaction in the specified date period. If no presence data was supplied to \code{\link{elo.seq}}, it is assumed that all individuals were present at all times}

\item{winners}{vector of winners (see details)}

\item{losers}{vector of losers (see details)}

\item{draw}{logical vector (currently not doing anything)}
}
\value{
square matrix with dominance interactions (winner in rows, loser in columns)
}
\description{
create a dominance matrix from the underlying observed sequence
}
\details{
The function works with either the output of \code{\link{elo.seq}}, or with two vectors of winners and losers. If you use winner and loser vectors, their arguments need to be named, and also the remaining arguments (\code{daterange=} and \code{onlyinteracting=}) are ignored. The function does not yet allow to include draws if you supply winner/loser vectors. If you go via the \code{\link{elo.seq}}-route, the function can handle draws (via the \code{drawmethod=} argument).
}
\examples{
data(adv)
# from winner/loser sequence directly
creatematrix(winners=adv$winner, losers=adv$loser)
# via an eloobject
SEQ <- elo.seq(winner=adv$winner, loser=adv$loser, Date=adv$Date)
# create dyadic matrix over the entire period of data collection
creatematrix(SEQ)
# limit to a subset of interactions
creatematrix(SEQ, daterange=c("2010-01-25", "2010-02-01"))
# limit to a subset of interactions and show only those IDs that were
# involved in at least one interaction
creatematrix(SEQ, daterange=c("2010-01-25", "2010-02-01"),
             onlyinteracting=TRUE)

## dealing with undecided interactions
data(adv2)
SEQ <- elo.seq(winner=adv2$winner, loser=adv2$loser, Date=adv2$Date,
               draw=adv2$tie)
# omit ties/draws
creatematrix(SEQ)
# omit ties/draws
creatematrix(SEQ, drawmethod="0.5")
# omit ties/draws
creatematrix(SEQ, drawmethod="1")
}
\author{
Christof Neumann
}
