% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/totalvoc.R
\name{totalVOC}
\alias{totalVOC}
\title{Calculate Total VOCs emissions}
\format{Return a list with the daily total emission by territory.}
\usage{
totalVOC(v, ef, pol, verbose = T)
}
\arguments{
\item{v}{data frame with the vehicle data}

\item{ef}{emission factors}

\item{pol}{pollutant name in ef}

\item{verbose}{display additional information}
}
\description{
Calculate Volatile Organic Compounds (COVs) emited by the process of exhaust (through the exhaust pipe), liquid (carter and evaporative) and vapor (fuel transfer operations).

 Avaliable COVs are: eth, hc3, hc5, hc8, ol2, olt, oli, iso, tol, xyl, ket, ch3oh and ald
}
\note{
The same ef can be used to totalEmission and voc
}
\examples{
veic <- vehicles(example = TRUE)

COV = c("eth","hc3","hc5","hc8","ol2","olt","oli","iso","tol","xyl","ket","ch3oh","ald")
EF_COV <- as.data.frame(matrix(NA,ncol = 9,nrow = 8,byrow = TRUE),
                        row.names = row.names(veic))
names(EF_COV) <-  c("vap_g","vap_e","vap_d",
                    "liq_g","liq_e","liq_d",
                    "exa_g","exa_e","exa_d")

EF_COV["vap_g"]  <- c(0.230,0.00,0.120,0.00,0.00,0.00,0.00,0.00)
EF_COV["vap_e"]  <- c(0.000,0.25,0.120,0.00,0.00,0.00,0.00,0.00)
EF_COV["vap_d"]  <- c(0.000,0.00,0.000,0.00,0.00,0.00,0.00,0.00)
EF_COV["liq_g"]  <- c(2.000,0.00,0.875,0.00,0.00,0.00,1.20,0.00)
EF_COV["liq_e"]  <- c(0.000,1.50,0.875,0.00,0.00,0.00,0.00,1.20)
EF_COV["liq_d"]  <- c(0.000,0.00,0.000,0.00,0.00,0.00,0.00,0.00)
EF_COV["exa_g"]  <- c(0.425,0.00,0.217,0.00,0.00,0.00,1.08,0.00)
EF_COV["exa_e"]  <- c(0.000,1.30,0.217,0.00,0.00,0.00,0.00,1.08)
EF_COV["exa_d"]  <- c(0.000,0.00,0.000,2.05,0.00,0.00,0.00,0.00)

print(EF_COV)

COV_total <- totalVOC(veic,EF_COV,pol = COV[10])
}
\seealso{
\code{\link{totalEmission}} and \code{\link{vehicles}}
}
