% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/totalEmission.R
\name{totalEmission}
\alias{totalEmission}
\title{Calculate total emissions}
\format{Return a list with the daily total emission by interest area (cityes, states, countries, etc).}
\usage{
totalEmission(v, ef, pol, verbose = T)
}
\arguments{
\item{v}{dataframe with the vehicle data}

\item{ef}{emission factor}

\item{pol}{pollutant name in ef}

\item{verbose}{display additional information}
}
\description{
Caculate the total emission with:

  Emission(pollutant) = sum( Vehicles(n) * Km_day_use(n) * Emission_Factor(n,pollutant) )

where n is the type of the veicle
}
\note{
the units (set_units("value",unit) where the recomended unit is g/d) must be used to make the ef data.frame
}
\examples{
veic <- vehicles(example = TRUE)

EmissionFactors <- emissionFactor(example = TRUE)

TOTAL <- totalEmission(veic,EmissionFactors,pol = c("CO","PM"))
}
\seealso{
\code{\link{rasterSource}}, \code{\link{lineSource}} and \code{\link{emission}}
}
