% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plotTrueAndObserved}
\alias{plotTrueAndObserved}
\title{Plot true and observed values}
\usage{
plotTrueAndObserved(logRr, seLogRr, trueLogRr, xLabel = "Relative risk",
  fileName = NULL)
}
\arguments{
\item{logRr}{A numeric vector of effect estimates on the log scale.}

\item{seLogRr}{The standard error of the log of the effect estimates. Hint: often the standard
error = (log(<lower bound 95 percent confidence interval>) - log(<effect
estimate>))/qnorm(0.025).}

\item{trueLogRr}{A vector of the true effect sizes.}

\item{xLabel}{The label on the x-axis: the name of the effect estimate.}

\item{fileName}{Name of the file where the plot should be saved, for example 'plot.png'. See the
function \code{ggsave} in the ggplot2 package for supported file formats.}
}
\value{
A Ggplot object. Use the \code{ggsave} function to save to file.
}
\description{
Plot true and observed values, for example from a simulation study.
}
\details{
Creates a forest plot of effect size estimates (ratios). Estimates that are significantly different
from the true value (alpha = 0.05) are marked in orange, others are marked in blue.
}
\examples{
data <- simulateControls(n = 50 * 3, mean = 0.25, sd = 0.25, trueLogRr = log(c(1, 2, 4)))
plotTrueAndObserved(data$logRr, data$seLogRr, data$trueLogRr)

}

