% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Idist.R
\name{Idist}
\alias{Idist}
\title{Density function and discrete distribution for a disease interval}
\usage{
Idist(mean, sd, dist = c("gamma", "weibull", "lognorm"), probs = NULL)
}
\arguments{
\item{mean}{The mean of the disease interval (must be larger than 1).}

\item{sd}{A positive and finite real number corresponding to the standard
deviation of the disease interval.}

\item{dist}{A choice among a Gamma, Weibull or Log-normal distribution for
the disease interval.}

\item{probs}{A vector of probabilities for the interval distribution.}
}
\value{
A list of class \code{Idist} containing a vector of probabilities
corresponding to the discrete distribution of the disease interval,
the name of the chosen parametric distribution and its parameters.
}
\description{
This function computes the probability density function and probability mass
function for a disease interval (e.g. the serial interval defined as the time
elapsed between the symptom onset in an infector and the onset of
symptoms in the secondary cases generated by that infector). It takes as
input the mean and the standard deviation of the disease interval (expressed
 in days) and gives as an output the interval distribution based on
a chosen parametric family.
}
\details{
The discretization is based on the formula in Held et al. (2019).
}
\examples{
Idist(mean = 2.6, sd = 1.5)

}
\references{
Held, L., Hens, N., D O'Neill, P., and Wallinga, J. (2019).
Handbook of infectious disease data analysis. \emph{CRC Press}.
}
\author{
Oswaldo Gressani \email{oswaldo_gressani@hotmail.fr}
}
