% Generated by roxygen2 (4.0.1): do not edit by hand
\name{dissolution_coefs}
\alias{dissolution_coefs}
\title{Dissolution Coefficients for Stochastic Network Models}
\usage{
dissolution_coefs(dissolution, duration, d.rate = 0)
}
\arguments{
\item{dissolution}{a right-hand sided STERGM dissolution formula
(see \code{\link{netest}}); currently limited to a \code{~offset(edges)}
dissolution model.}

\item{duration}{an average edge duration in arbitrary time units.}

\item{d.rate}{death/exit rate in the absence of disease.}
}
\value{
A list of class \code{disscoef} with the following elements:
\itemize{
 \item \strong{dissolution:} the right-hand sided STERGM dissolution formula
        passed in the function call.
 \item \strong{duration:} the average edge duration passed in the function
       call.
 \item \strong{coef.crude:} the average duration transformed into a logit
       coefficient for use in STERGM simulations.
 \item \strong{coef.adj:} the crude coefficient adjusted for the impact of
       death on edge persistence, if the \code{d.rate} argument is supplied.
}
}
\description{
Calculates dissolution coefficients, given a dissolution model
             and average edge duration, to pass as offsets to an ERGM/STERGM
             model fit in \code{netest}.
}
\details{
This function performs two calculations to obtain a dissolution coefficient
used in a network model estimated with \code{\link{netest}}:
\enumerate{
 \item \strong{Transformation:} the average duration of edges in a network are
       mathematically transformed to logit coefficients.
 \item \strong{Adjustment:} In a dynamic network simulation in an open
       population (in which there are births and deaths), it is necessary to
       adjust the dissolution coefficient for the STERGM simulations to account
       for the death as a competing risk to edge dissolution.
}

Future releases of \code{EpiModel} will allow for more flexibility in the
possible dissolution models that may be calculated, including models with
heterogenous dissolution probabilities conditional on nodal or edge attributes.
}
\examples{
dissolution <- ~offset(edges)
duration <- 25
dissolution_coefs(dissolution, duration)
dissolution_coefs(dissolution, duration, d.rate = 0.001)
}
\seealso{
The theory and details of this function are explained in detail in the
\href{http://statnet.org/EpiModel/vignette/NetUtils.html}{EpiModel Network
Utility Functions} tutorial.
}
\keyword{netUtils}

