% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{add_vertices}
\alias{add_vertices}
\title{Fast Version of network::add.vertices for Edgelist-formatted Network}
\usage{
add_vertices(el, nv)
}
\arguments{
\item{el}{A two-column matrix of current edges (edgelist) with an attribute
variable \code{n} containing the total current network size.}

\item{nv}{A integer equal to the number of nodes to add to the network
size at the given time step.}
}
\value{
Returns the matrix of current edges, \code{el}, with the population size
attribute updated based on the number of new vertices specified in \code{nv}.
}
\description{
This function performs a simple operation of updating the
edgelist attribute \code{n} that tracks the total network
size implicit in an edgelist representation of the network.
}
\details{
This function is used in \code{EpiModel} modules to add vertices (nodes) to
the edgelist object to account for entries into the population (e.g., births
and in-migration).
}
\examples{
\dontrun{
library("EpiModel")
nw <- network_initialize(100)
formation <- ~edges
target.stats <- 50
coef.diss <- dissolution_coefs(dissolution = ~offset(edges), duration = 20)
x <- netest(nw, formation, target.stats, coef.diss, verbose = FALSE)

param <- param.net(inf.prob = 0.3)
init <- init.net(i.num = 10)
control <- control.net(type = "SI", nsteps = 100, nsims = 5,
                       tergmLite = TRUE)

# networkLite representation after initialization
dat <- crosscheck.net(x, param, init, control)
dat <- initialize.net(x, param, init, control)

# Check current network size
attributes(dat$el[[1]])$n

# Add 10 vertices
dat$el[[1]] <- add_vertices(dat$el[[1]], 10)

# Check new network size
attributes(dat$el[[1]])$n
}

}
