% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{bootstrapped_dist_fit}
\alias{bootstrapped_dist_fit}
\title{Fit a Subsampled Bootstrap to Integer Values and Summarise Distribution Parameters}
\usage{
bootstrapped_dist_fit(
  values,
  dist = "lognormal",
  samples = 2000,
  bootstraps = 10,
  bootstrap_samples = 250,
  verbose = FALSE
)
}
\arguments{
\item{values}{Numeric vector of integer values.}

\item{dist}{Character string, which distribution to fit. Defaults to lognormal (\code{"lognormal"}) but
gamma (\code{"gamma"}) is also supported.}

\item{samples}{Numeric, number of samples to take overall from the bootstrapped posteriors.}

\item{bootstraps}{Numeric, defaults to 1. The number of bootstrap samples (with replacement)
of the delay distribution to take.}

\item{bootstrap_samples}{Numeric, defaults to 100. The number of samples to take in each bootstrap.
When the sample size of the supplied delay distribution is less than 100 this is used instead.}

\item{verbose}{Logical, defaults to \code{FALSE}. Should progress messages be printed}
}
\value{
A list summarising the bootstrapped distribution
}
\description{
Fit a Subsampled Bootstrap to Integer Values and Summarise Distribution Parameters
}
\examples{

\donttest{
# lognormal
delays <- rlnorm(500, log(5), 1)

out <- bootstrapped_dist_fit(delays, samples = 1000, bootstraps = 10, 
                             dist = "lognormal")

## Inspect
out

}
}
