% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{filter_opts}
\alias{filter_opts}
\title{Filter Options for a Target Region}
\usage{
filter_opts(opts, region)
}
\arguments{
\item{opts}{Either a list of calls to an \verb{_opts} function or a single
call to an \verb{_opts} function.}

\item{region}{A character string indicating a region of interest.}
}
\value{
A list of options
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#maturing'><img src='figures/lifecycle-maturing.svg' alt='Maturing lifecycle'></a>}}{\strong{Maturing}}
A helper function that allows the selection of region specific settings if
present and otherwise applies the overarching settings
}
\examples{
# uses example case vector
cases <- example_confirmed[1:40]
cases <- data.table::rbindlist(list(
  data.table::copy(cases)[, region := "testland"],
  cases[, region := "realland"]))
  
# regional options
regional_opts <- opts_list(rt_opts(), cases)
EpiNow2:::filter_opts(regional_opts, "realland")
# default only
EpiNow2:::filter_opts(rt_opts(), "realland")
#settings are NULL in one regions
regional_opts <- update_list(regional_opts, list(realland = NULL))
EpiNow2:::filter_opts(regional_opts, "realland")
}
