% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climatch_sum.R
\name{climatch_sum}
\alias{climatch_sum}
\title{Climatch Summary Score}
\usage{
climatch_sum(recipient, source, globvar, type = "perc", threshold = 6)
}
\arguments{
\item{recipient}{A data.frame or list of data.frames of climatic variables for the recipient region.}

\item{source}{A data.frame or list of data.frames of climatic variables for the source region.}

\item{globvar}{A vector of the global variance of each climate variable.}

\item{type}{Specifies the type of summary score to use. "perc" (default) specifies a percent climatch score representing the number of grid cells above or equal to a given value specified with the 'thershold' argument. "mean" provides the mean climatch score across the recipient region.}

\item{threshold}{The climatch score to use in calculating the percentage match, which is the number of grid cells within the recipient region with a climatch >= the threshold (default is 6).}
}
\value{
A numeric value, vector or data.frame of the percentage of climatch scores within the recipient region(s) >= a threshold value, or the mean climatch score across the region(s).
}
\description{
A summarized climatch score within the recipient region to a source region. Provides the percentage of climate data points in the recipient region equal to or above a specified score (default is 6), or the mean climatch score across the whole recipient region. Note no floor function is used as in Crombie et al. (2008)
}
\examples{
i <- as.data.frame(matrix(runif(n=180, min=1, max=20), nrow=60)) # Fake source climate data
j <- as.data.frame(matrix(runif(n=300, min=10, max=40), nrow=100)) # Fake recipient data
variance <- c(600, 800, 450) # Fake global variance

climatch_sum(recipient = j, source = i, globvar = variance, type = "perc", threshold = 6)

}
\references{
Predicting invasiveness of species in trade: climate match, trophic guild and fecundity influence establishment and impact of non-native freshwater fishes"<doi:10.1111/ddi.12391>
}
