% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plotLikelihoodFit}
\alias{plotLikelihoodFit}
\title{Plot the likelihood approximation}
\usage{
plotLikelihoodFit(
  approximation,
  cyclopsFit,
  parameter = "x",
  logScale = TRUE,
  xLabel = "Hazard Ratio",
  limits = c(0.1, 10),
  fileName = NULL
)
}
\arguments{
\item{approximation}{An approximation of the likelihood function as fitted using the
\code{\link[=approximateLikelihood]{approximateLikelihood()}} function.}

\item{cyclopsFit}{A model fitted using the \code{\link[Cyclops:fitCyclopsModel]{Cyclops::fitCyclopsModel()}} function.}

\item{parameter}{The parameter in the \code{cyclopsFit} object to profile.}

\item{logScale}{Show the y-axis on the log scale?}

\item{xLabel}{The title of the x-axis.}

\item{limits}{The limits on the x-axis.}

\item{fileName}{Name of the file where the plot should be saved, for example 'plot.png'. See
the function \link[ggplot2:ggsave]{ggplot2::ggsave} in the ggplot2 package for supported file
formats.}
}
\value{
A Ggplot object. Use the \link[ggplot2:ggsave]{ggplot2::ggsave} function to save to file.
}
\description{
Plot the likelihood approximation
}
\details{
Plots the (log) likelihood and the approximation of the likelihood. Allows for reviewing the
approximation.
}
\examples{
# Simulate a single database population:
population <- simulatePopulations(createSimulationSettings(nSites = 1))[[1]]

# Approximate the likelihood:
cyclopsData <- Cyclops::createCyclopsData(Surv(time, y) ~ x + strata(stratumId),
                                          data = population,
                                          modelType = "cox")
cyclopsFit <- Cyclops::fitCyclopsModel(cyclopsData)
approximation <- approximateLikelihood(cyclopsFit, parameter = "x", approximation = "custom")

plotLikelihoodFit(approximation, cyclopsFit, parameter = "x")

}
