% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask_pixels.R
\name{mask_pixels}
\alias{mask_pixels}
\title{Creates a mask over the background or foreground (Cria uma mascara sobre o
background ou foreground)}
\usage{
mask_pixels(im,TargetPixels,TargetPixels2=NULL,plot=FALSE)
}
\arguments{
\item{im}{:Este objeto deve conter uma imagem no formato do EBImage.}

\item{TargetPixels}{: Este objeto deve ser obrigatoriamente uma matriz
binaria, contendo os valores 0 (pixels do background) ou 1 (pixels do
foreground)).}

\item{TargetPixels2}{: Este objeto pode ter o valor "NULL" caso haja
apenas uma mascara a ser destacada sobre a imagem. Se quiser usar duas
mascaras, neste objeto deve ter obrigatoriamente uma matriz binaria,
contendo os valores 0 (pixels do background) ou 1 (pixels do foreground)).}

\item{plot}{:Indica se sera apresentada (TRUE) ou nao (FALSE) (default) a
imagem segmentada.}
}
\value{
Retorna uma imagem com uma mascara sobre os  pixels selecionados.
}
\description{
Esta funcao permite criar mascara sobre os pixels
  correspondentes ao background ou foreground
}
\examples{
###########################################################################
#Estimar a area atacada por doenca no tomateiro
###########################################################################

  im=read_image(example_image(ex=7))
  plot(im)

  #Selecionando o melhor indice para a segmentacao da folha
  r=gray_scale(im,method = "r",plot=TRUE)
  g=gray_scale(im,method = "g",plot=TRUE)
  b=gray_scale(im,method = "b",plot=TRUE)

  #O limiar pode ser um valor escolhido aleatoriamente
  MatrizSegentada=segmentation(b,treshold = 0.5,fillHull = FALSE,plot=TRUE)

  #O limiar tambem pode ser estabelecido pelo metodo de otsu
  MatrizSegentada2=segmentation(b,treshold = "otsu",fillHull = TRUE
  ,selectHigher= FALSE, plot=TRUE)


  #Selecionar na imagem apenas os pixeis desejaveis (Folha)
  im2=extract_pixels(im,target=MatrizSegentada2,valueTarget=TRUE,
  valueSelect=c(r=1,g=1,b=1),plot=TRUE)

  ################################################################
  #Selecionando o melhor indice para a segmentacao da doenca
  r=gray_scale(im2,method = "r",plot=TRUE)
  g=gray_scale(im2,method = "g",plot=TRUE)
  b=gray_scale(im2,method = "b",plot=TRUE)

  MatrizSegmentada3=segmentation(g,treshold = 0.3,selectHigher = FALSE,
  fillHull =TRUE,plot=TRUE)


  #Como pode-se obsevar, a segmentacao por limiar nao e possivel. Entao vamos
  #usar paletas de cores
  folha=read_image(example_image(ex=8))
  doenca=read_image(example_image(ex=9))

  DoencaSeg=segmentation_logit(im,foreground = doenca,background =
  folha,sample = 2000,fillHull = TRUE,TargetPixels =MatrizSegentada2==1
  ,plot=TRUE)

  im3=mask_pixels(im2,TargetPixels=DoencaSeg==1)
   plot(im3)

  ii=join_image(im,im3,plot=TRUE)


  #Porcentagem da area lesionada.

  100*(sum(DoencaSeg)/sum(MatrizSegentada2))
}
