% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_pallete.R
\name{color_pallete}
\alias{color_pallete}
\title{Creates a color palette from an image (Criar uma paleta de cores a partir de uma imagem).}
\usage{
color_pallete(im,number=8,mask=NULL,proportional=FALSE,plot=TRUE)
}
\arguments{
\item{im}{:Image in ExpImage format (Imagem no formato do ExpImage).}

\item{number}{:Number of color scales to be created (Numero de escalas de cores a serem criados)}

\item{mask}{: Mask obtained by the segmentation process, default=NULL (Mascara obtida pelo processo de segmentacao).}

\item{proportional}{:Logical variable indicating whether the pixel quantity of each color will be proportional to the original image
(Variavel logica indicando se a quantidade pixel de cada cor sera proporcional à da imagem original).}

\item{plot}{: Logical value, if TRUE, the image will be displayed
(Valor logico, se for TRUE a imagem sera apresentada).}
}
\value{
Returns the segmented image (Retorna a imagem segmentada).
}
\description{
Creates a color palette from an image (Criar uma paleta de cores a partir de uma imagem)
}
\examples{
\donttest{
name=example_image(3)
image=read_image(name,plot=TRUE)
pallete=color_pallete(im=image,number =5,plot = TRUE)
pallete=color_pallete(im=image,number =5,proportional = TRUE,plot = TRUE)

name=example_image(10)
image=read_image(name,plot=TRUE)
pallete=color_pallete(im=image,number =5,plot = TRUE)
pallete=color_pallete(im=image,number =5,proportional = TRUE,plot = TRUE)

m=gray_scale(image,method = "GLI",plot=TRUE)
seg=segmentation(m,treshold = 0.25,plot=TRUE)
pallete1=color_pallete(im=image,number =10,mask = seg,plot = TRUE)
pallete2=color_pallete(im=image,number =10,mask = seg,proportional = TRUE,plot = TRUE)


name=example_image(13)
image=read_image(name,plot=TRUE)
pallete1=color_pallete(im=image,number =10,plot = TRUE)
pallete2=color_pallete(im=image,number =10,proportional = TRUE,plot = TRUE)

m=gray_scale(image,method = "r",plot=TRUE)
seg=segmentation(m,treshold = "otsu",fillHull = TRUE,plot=TRUE)
pallete1=color_pallete(im=image,number =10,mask = seg,plot = TRUE)
pallete2=color_pallete(im=image,number =10,mask = seg,proportional = TRUE,plot = TRUE)

}
}
\seealso{
\code{\link{segmentation}} , \code{\link{calibration_palette}}
}
\author{
Alcinei Mistico Azevedo (Instituto de ciencias agrarias da UFMG)
}
