% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parscale_famos_function.R
\name{parscale.famos}
\alias{parscale.famos}
\title{Control Function for Optim}
\usage{
parscale.famos(par, scale, fix = 1, correction = NULL)
}
\arguments{
\item{par}{A vector containing the values of the original parameters.}

\item{scale}{A vector containing the corresponding absolute scaling values that will be used during the first steps in \code{\link{optim}}.}

\item{fix}{Integer containing the index of the parameter that will be scaled by 10\% of its original value, meaning the corresponding entry in scale will be overwritten (\code{parscale} in \code{\link{optim}} needs one value like this). Default to 1.}

\item{correction}{Used for scaling newly added parameter values by their original scale as specified in \code{init.par} in \code{\link{famos}}. Default to NULL.}
}
\value{
A vector that can be used to scale \code{parscale} in \code{\link{optim}} accordingly.
}
\description{
This function is designed to use the built-in option \code{parscale} in \code{\link{optim}} with absolute scaling values.
}
\examples{
test.func<-function(x){
print(x)
3*x[1]+4*x[2]
}

pars <- c(1, 1000, 10)
scaling <- c(0.1, 3000, 10)

p.scale <- parscale.famos(par = pars, scale = scaling)

optim(par = pars, fn = test.func, control = list(maxit = 10, parscale = p.scale, trace = TRUE))

}
