% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_fava.R
\name{plot_relabund}
\alias{plot_relabund}
\title{Visualize a relative abundance matrix as a stacked bar plot.}
\usage{
plot_relabund(
  relab_matrix,
  group = NULL,
  time = NULL,
  w = NULL,
  K = NULL,
  arrange = FALSE
)
}
\arguments{
\item{relab_matrix}{A matrix or data frame with rows containing non-negative entries that sum to 1. Each row represents
a sample, each column represents a category, and each entry represents the abundance of that category in the sample.
If \code{relab_matrix} contains any metadata, it must be on the left-hand side of the matrix,
the right \code{K} entries of each row must sum to 1, and \code{K} must be specified. Otherwise, all entries of
each row must sum to 1.}

\item{group}{Optional; a string specifying the name of the column that describes which group each row (sample) belongs to. Use if \code{matrices} is a single matrix containing multiple groups of samples you wish to compare.}

\item{time}{Optional; a string specifying the name of the column that describes the sampling time for each row. Include if you wish to weight FAVA by the distance between samples.}

\item{w}{Optional; a vector of length \code{I} with non-negative entries that sum to 1. Entry \code{w[i]} represents the weight placed on row \code{i} in the computation of the mean abundance of each category across rows. The default value is \code{w = rep(1/nrow(relab_matrix), nrow(relab_matrix))}.}

\item{K}{Optional; an integer specifying the number of categories in the data. Default is \code{K=ncol(relab_matrix)}.}

\item{arrange}{Optional; controls horizontal ordering of samples and vertical ordering of categories.
If \code{arrange = TRUE} or \code{arrange = "both"}, samples are ordered by the categories of greatest
abundance and categories are ordered in decreasing abundance. If \code{arrange = "vertical"}, sample
order is unchanged but categories are ordered in decreasing abundance. If \code{arrange = "horizontal"},
samples are ordered by the most abundant categories, but category order is unchanged. If \code{arrange} is missing
or \code{arrange = FALSE}, neither order is changed.}
}
\value{
A ggplot object containing a bar plot visualization of the relative abundance matrix.
}
\description{
This function enables graphical visualization of a matrix of compostional data.
In the output plot, each vertical bar represents a single vector;
the height of each color in the bar corresponds to the abundance of each category
in that vector. Because this function produces a
ggplot object, its output can be modified using
standard ggplot2 syntax.
}
\examples{

# Make an example matrix of compositional data
# Each row is an individual. Rows sum to 1.
population_A = matrix(c(
    .5, .3, .2,
    .4, .2, .4,
    .5, .4, .1,
    .6, .1, .3,
    .2, 0, .8
  ),
  nrow = 5,
  byrow = TRUE
  )

  plot_relabund(relab_matrix = population_A,
              K = 3, # How many categories per vector?
              arrange = FALSE
              )
  plot_relabund(relab_matrix = population_A,
              K = 3, # How many categories per vector?
              arrange = "horizontal"
              )
  plot_relabund(relab_matrix = population_A,
              K = 3, # How many categories per vector?
              arrange = "vertical"
              )
   plot_relabund(relab_matrix = population_A,
              K = 3, # How many categories per vector?
              arrange = TRUE  # could also be "both"
              )


# You can modify the plot as you would any ggplot2 object
plot_relabund(relab_matrix = population_A,
              K = 3, # How many categories per vector?
              arrange = TRUE
              ) +
  # Below are example, optional modifications to the default plot
  ggplot2::ggtitle("Population A") +
  ggplot2::scale_fill_brewer("Blues") +
  ggplot2::scale_color_brewer("Blues") +
  ggplot2::xlab("Individuals")
  # Note that both scale_fill and scale_color are needed to change the color of the bars.


  # Plot a dataset which has 2 populations

  population_B = matrix(c(
    .9, 0, .1,
    .6, .4, 0,
    .7, 0, .3,
    .3, .4, .3,
    .5, .3, .2
  ),
  nrow = 5,
  byrow = TRUE
  )


  populations_AB = cbind(data.frame(c("A", "A", "A", "A", "A",
                                     "B", "B", "B", "B", "B")),
                         rbind(population_A, population_B))
  colnames(populations_AB) = c("population", "category_1", "category_2", "category_3")


 plot_relabund(relab_matrix = populations_AB, group = "population")
 plot_relabund(relab_matrix = populations_AB, group = "population", arrange = "vertical")
 plot_relabund(relab_matrix = populations_AB, group = "population", arrange = "horizontal")
 plot_relabund(relab_matrix = populations_AB, group = "population", arrange = "both")


}
